/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.weka.ranking.label.learner.clusterbased.modifiedisac;

import ai.libs.jaicore.ml.ranking.label.learner.clusterbased.customdatatypes.ProblemInstance;
import java.util.List;
import weka.core.Instance;

public class Normalizer {
    private int numbervaluesToNormalize;
    private double[] maxvalues;
    private List<ProblemInstance<Instance>> basisForNormalization;

    public Normalizer(List<ProblemInstance<Instance>> list) {
        this.numbervaluesToNormalize = ((Instance)list.get(0).getInstance()).numAttributes();
        this.maxvalues = new double[this.numbervaluesToNormalize];
        this.basisForNormalization = list;
    }

    public void setupnormalize() {
        for (ProblemInstance<Instance> i : this.basisForNormalization) {
            double[] instacnevector = ((Instance)i.getInstance()).toDoubleArray();
            for (int j = 0; j < instacnevector.length; ++j) {
                if (Double.isNaN(instacnevector[j])) {
                    if (!Double.isNaN(this.maxvalues[j])) continue;
                    this.maxvalues[j] = Double.NaN;
                    continue;
                }
                if (Double.isNaN(this.maxvalues[j])) {
                    this.maxvalues[j] = Math.abs(instacnevector[j]);
                    continue;
                }
                if (!(Math.abs(instacnevector[j]) > this.maxvalues[j])) continue;
                this.maxvalues[j] = Math.abs(instacnevector[j]);
            }
        }
    }

    public double[] normalize(double[] vectorToNormalize) {
        for (int i = 0; i < vectorToNormalize.length; ++i) {
            if (Double.isNaN(this.maxvalues[i])) {
                if (Double.isNaN(vectorToNormalize[i])) {
                    vectorToNormalize[i] = Double.NaN;
                    continue;
                }
                if (vectorToNormalize[i] < 0.0) {
                    vectorToNormalize[i] = -1.0;
                    continue;
                }
                vectorToNormalize[i] = 1.0;
                continue;
            }
            if (Double.isNaN(vectorToNormalize[i])) {
                vectorToNormalize[i] = Double.NaN;
            }
            if (Math.abs(vectorToNormalize[i]) > this.maxvalues[i]) {
                vectorToNormalize[i] = vectorToNormalize[i] >= 0.0 ? 1.0 : -1.0;
            }
            vectorToNormalize[i] = vectorToNormalize[i] < 0.0 ? (Math.abs(vectorToNormalize[i]) / this.maxvalues[i] * 2.0 - 1.0) * -1.0 : Math.abs(vectorToNormalize[i]) / this.maxvalues[i] * 2.0 - 1.0;
        }
        return vectorToNormalize;
    }
}

