/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.weka.classification.pipeline.featuregen;

import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.ml.weka.classification.pipeline.PreprocessingException;
import ai.libs.jaicore.ml.weka.classification.pipeline.featuregen.FeatureGenerator;
import java.util.ArrayList;
import java.util.List;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class InteractingFeatures
implements FeatureGenerator {
    private boolean isPrepared;
    private List<Integer> indicesToInteract = new ArrayList<Integer>();

    @Override
    public void prepare(Instances data) throws PreprocessingException {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        this.indicesToInteract.clear();
        for (int i = 0; i < data.numAttributes(); ++i) {
            if (!data.attribute(i).isNumeric()) continue;
            attributes.add(new Attribute("q" + i, false));
            this.indicesToInteract.add(i);
        }
        this.isPrepared = true;
    }

    private Instances getEmptyDataset() {
        if (!this.isPrepared) {
            throw new IllegalStateException("Cannot get empty dataset before preparation");
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (Pair pair : SetUtil.cartesianProduct(this.indicesToInteract, this.indicesToInteract)) {
            if ((Integer)pair.getX() >= (Integer)pair.getY()) continue;
            attributes.add(new Attribute("interaction_" + pair.getX() + "_" + pair.getY(), false));
        }
        return new Instances("interaction", attributes, 0);
    }

    @Override
    public Instance apply(Instance data) throws PreprocessingException {
        DenseInstance newInstance = new DenseInstance(((int)Math.pow(this.indicesToInteract.size(), 2.0) - this.indicesToInteract.size()) / 2);
        int index = 0;
        for (Pair pair : SetUtil.cartesianProduct(this.indicesToInteract, this.indicesToInteract)) {
            if ((Integer)pair.getX() >= (Integer)pair.getY()) continue;
            newInstance.setValue(index++, data.value(((Integer)pair.getX()).intValue()) * data.value(((Integer)pair.getY()).intValue()));
        }
        Instances dataset = this.getEmptyDataset();
        dataset.add((Instance)newInstance);
        newInstance.setDataset(dataset);
        return newInstance;
    }

    @Override
    public Instances apply(Instances data) throws PreprocessingException {
        Instances newDataset = this.getEmptyDataset();
        for (Instance inst : data) {
            Instance modInst = this.apply(inst);
            newDataset.add(modInst);
            modInst.setDataset(newDataset);
        }
        return newDataset;
    }

    @Override
    public boolean isPrepared() {
        return this.isPrepared;
    }
}

