/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.weka.rangequery.learner.intervaltree.featurespace;

import ai.libs.jaicore.basic.sets.Interval;
import ai.libs.jaicore.ml.weka.rangequery.learner.intervaltree.featurespace.FeatureDomain;

public class NumericFeatureDomain
extends FeatureDomain {
    private static final long serialVersionUID = 7137323856374433244L;
    private final Interval interval;

    public NumericFeatureDomain(boolean isInteger, double min, double max) {
        this.interval = new Interval(isInteger, min, max);
    }

    public NumericFeatureDomain(NumericFeatureDomain domain) {
        this(domain.isInteger(), domain.getMin(), domain.getMax());
    }

    public boolean isInteger() {
        return this.interval.isInteger();
    }

    public double getMin() {
        return this.interval.getMin();
    }

    public double getMax() {
        return this.interval.getMax();
    }

    public void setMin(double min) {
        this.interval.setMin(min);
    }

    public void setMax(double max) {
        this.interval.setMax(max);
    }

    public String toString() {
        return "NumericFeatureDomain [isInteger=" + this.isInteger() + ", min=" + this.getMin() + ", max=" + this.getMax() + "]";
    }

    @Override
    public boolean contains(Object item) {
        return this.interval.contains(item);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.interval == null ? 0 : this.interval.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumericFeatureDomain other = (NumericFeatureDomain)obj;
        return !(this.interval == null ? other.interval != null : !this.interval.equals((Object)other.interval));
    }

    @Override
    public double getRangeSize() {
        double temp = this.getMax() - this.getMin();
        if (temp == 0.0) {
            return 1.0;
        }
        return temp;
    }

    @Override
    public boolean containsInstance(double value) {
        return this.contains(value);
    }

    @Override
    public String compactString() {
        return "[" + this.getMin() + "," + this.getMax() + "]";
    }
}

