/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.weka.classification.singlelabel.timeseries.learner.trees;

import ai.libs.jaicore.basic.IOwnerBasedAlgorithmConfig;
import ai.libs.jaicore.basic.IOwnerBasedRandomizedAlgorithmConfig;
import ai.libs.jaicore.ml.classification.singlelabel.timeseries.dataset.TimeSeriesDataset2;
import ai.libs.jaicore.ml.classification.singlelabel.timeseries.learner.ASimplifiedTSCLearningAlgorithm;
import ai.libs.jaicore.ml.classification.singlelabel.timeseries.learner.ASimplifiedTSClassifier;
import ai.libs.jaicore.ml.weka.classification.singlelabel.timeseries.learner.trees.TimeSeriesForestClassifier;
import ai.libs.jaicore.ml.weka.classification.singlelabel.timeseries.learner.trees.TimeSeriesTreeClassifier;
import ai.libs.jaicore.ml.weka.classification.singlelabel.timeseries.learner.trees.TimeSeriesTreeLearningAlgorithm;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.ConfigCache;
import org.api4.java.algorithm.exceptions.AlgorithmException;

public class TimeSeriesForestLearningAlgorithm
extends ASimplifiedTSCLearningAlgorithm<Integer, TimeSeriesForestClassifier> {
    public TimeSeriesForestLearningAlgorithm(ITimeSeriesForestConfig config, TimeSeriesForestClassifier classifier, TimeSeriesDataset2 data) {
        super((IOwnerBasedAlgorithmConfig)config, (ASimplifiedTSClassifier)classifier, data);
    }

    public ITimeSeriesForestConfig getConfig() {
        return (ITimeSeriesForestConfig)super.getConfig();
    }

    public TimeSeriesForestClassifier call() throws InterruptedException, AlgorithmException {
        int i;
        ITimeSeriesForestConfig config = this.getConfig();
        final TimeSeriesDataset2 dataset = (TimeSeriesDataset2)this.getInput();
        TimeSeriesTreeClassifier[] trees = new TimeSeriesTreeClassifier[config.numTrees()];
        ExecutorService execService = Executors.newFixedThreadPool(config.cpus());
        Future[] futures = new Future[config.numTrees()];
        for (i = 0; i < config.numTrees(); ++i) {
            TimeSeriesTreeLearningAlgorithm.ITimeSeriesTreeConfig configOfTree = (TimeSeriesTreeLearningAlgorithm.ITimeSeriesTreeConfig)ConfigCache.getOrCreate(TimeSeriesTreeLearningAlgorithm.ITimeSeriesTreeConfig.class, (Map[])new Map[0]);
            configOfTree.setProperty("maxdepth", "" + config.maxDepth());
            configOfTree.setProperty("seed", "" + config.seed() + i);
            configOfTree.setProperty("featurecaching", "" + config.useFeatureCaching());
            final TimeSeriesTreeClassifier tst = new TimeSeriesTreeClassifier(configOfTree);
            futures[i] = execService.submit(new Callable<TimeSeriesTreeClassifier>(){

                @Override
                public TimeSeriesTreeClassifier call() throws Exception {
                    tst.train(dataset);
                    return tst;
                }
            });
        }
        execService.shutdown();
        execService.awaitTermination(this.getTimeout().seconds(), TimeUnit.SECONDS);
        for (i = 0; i < config.numTrees(); ++i) {
            try {
                TimeSeriesTreeClassifier tst;
                trees[i] = tst = (TimeSeriesTreeClassifier)((Object)futures[i].get());
                continue;
            }
            catch (ExecutionException e) {
                throw new AlgorithmException("Could not train time series tree due to training exception: " + e.getMessage());
            }
        }
        ((TimeSeriesForestClassifier)this.getClassifier()).setTrees(trees);
        return (TimeSeriesForestClassifier)this.getClassifier();
    }

    public static interface ITimeSeriesForestConfig
    extends IOwnerBasedRandomizedAlgorithmConfig {
        public static final String K_NUMTREES = "numtrees";
        public static final String K_MAXDEPTH = "maxdepth";
        public static final String K_FEATURECACHING = "featurecaching";

        @Config.Key(value="numtrees")
        @Config.DefaultValue(value="-1")
        public int numTrees();

        @Config.Key(value="maxdepth")
        @Config.DefaultValue(value="-1")
        public int maxDepth();

        @Config.Key(value="featurecaching")
        @Config.DefaultValue(value="false")
        public boolean useFeatureCaching();
    }
}

