/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.weka.rangequery;

import ai.libs.jaicore.ml.weka.rangequery.IAugmentedSpaceSampler;
import java.util.List;
import java.util.Random;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public abstract class AbstractAugmentedSpaceSampler
implements IAugmentedSpaceSampler {
    private final Instances preciseInsts;
    private final Random rng;

    public AbstractAugmentedSpaceSampler(Instances preciseInsts, Random rng) {
        this.preciseInsts = preciseInsts;
        this.rng = rng;
    }

    protected static Instance generateAugPoint(List<Instance> insts) {
        if (insts.isEmpty()) {
            throw new IllegalArgumentException("Cannot generate augmented point from an empty list.");
        }
        int numAttributes = insts.get(0).numAttributes();
        DenseInstance augPoint = new DenseInstance(numAttributes * 2);
        for (int i = 0; i < numAttributes; ++i) {
            double lowerBound = Double.POSITIVE_INFINITY;
            double upperBound = Double.NEGATIVE_INFINITY;
            for (Instance inst : insts) {
                double attrValue = inst.value(i);
                lowerBound = Math.min(lowerBound, attrValue);
                upperBound = Math.max(upperBound, attrValue);
            }
            augPoint.setValue(2 * i, lowerBound);
            augPoint.setValue(2 * i + 1, upperBound);
        }
        return augPoint;
    }

    public Instances getPreciseInsts() {
        return this.preciseInsts;
    }

    public Random getRng() {
        return this.rng;
    }
}

