/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.weka.rangequery.learner.intervaltree;

import ai.libs.jaicore.ml.weka.rangequery.learner.intervaltree.ExtendedM5Tree;
import ai.libs.jaicore.ml.weka.rangequery.learner.intervaltree.RangeQueryPredictor;
import ai.libs.jaicore.ml.weka.rangequery.learner.intervaltree.aggregation.AggressiveAggregator;
import ai.libs.jaicore.ml.weka.rangequery.learner.intervaltree.aggregation.IntervalAggregator;
import ai.libs.jaicore.ml.weka.rangequery.learner.intervaltree.aggregation.QuantileAggregator;
import ai.libs.jaicore.ml.weka.rangequery.learner.intervaltree.util.RQPHelper;
import java.util.ArrayList;
import org.apache.commons.math3.geometry.euclidean.oned.Interval;
import weka.classifiers.Classifier;
import weka.classifiers.meta.Bagging;
import weka.core.Instance;

public class ExtendedM5Forest
extends Bagging
implements RangeQueryPredictor {
    private static final long serialVersionUID = 8774800172762290733L;
    private final IntervalAggregator forestAggregator;

    public ExtendedM5Forest() {
        this(new QuantileAggregator(0.15), new AggressiveAggregator());
    }

    public ExtendedM5Forest(IntervalAggregator treeAggregator, IntervalAggregator forestAggregator) {
        ExtendedM5Tree rTree = new ExtendedM5Tree(treeAggregator);
        rTree.setDoNotCheckCapabilities(false);
        super.setClassifier((Classifier)rTree);
        super.setRepresentCopiesUsingWeights(false);
        this.setNumIterations(this.defaultNumberOfIterations());
        this.forestAggregator = forestAggregator;
    }

    public ExtendedM5Forest(int seed) {
        this();
        this.setSeed(seed);
    }

    protected String defaultClassifierString() {
        return "jaicore.ml.intervaltree.ExtendedM5Tree";
    }

    @Override
    public Interval predictInterval(Instance rangeQuery) {
        ArrayList<Double> predictions = new ArrayList<Double>(this.m_Classifiers.length * 2);
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            ExtendedM5Tree classifier = (ExtendedM5Tree)this.m_Classifiers[i];
            Interval prediction = classifier.predictInterval(rangeQuery);
            predictions.add(prediction.getInf());
            predictions.add(prediction.getSup());
        }
        return this.forestAggregator.aggregate(predictions);
    }

    @Override
    public Interval predictInterval(RQPHelper.IntervalAndHeader intervalAndHeader) {
        ArrayList<Double> predictions = new ArrayList<Double>(this.m_Classifiers.length * 2);
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            ExtendedM5Tree classifier = (ExtendedM5Tree)this.m_Classifiers[i];
            Interval prediction = classifier.predictInterval(intervalAndHeader);
            predictions.add(prediction.getInf());
            predictions.add(prediction.getSup());
        }
        return this.forestAggregator.aggregate(predictions);
    }
}

