/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml;

import ai.libs.jaicore.basic.sets.CartesianProductComputationProblem;
import ai.libs.jaicore.basic.sets.LDSRelationComputer;
import ai.libs.jaicore.basic.sets.RelationComputationProblem;
import ai.libs.jaicore.ml.SubInstances;
import ai.libs.jaicore.ml.cache.ReproducibleInstances;
import ai.libs.jaicore.ml.cache.SplitInstruction;
import ai.libs.jaicore.ml.core.SimpleInstanceImpl;
import ai.libs.jaicore.ml.core.SimpleInstancesImpl;
import ai.libs.jaicore.ml.core.SimpleLabeledInstanceImpl;
import ai.libs.jaicore.ml.core.WekaCompatibleInstancesImpl;
import ai.libs.jaicore.ml.interfaces.Instance;
import ai.libs.jaicore.ml.interfaces.Instances;
import ai.libs.jaicore.ml.interfaces.LabeledInstance;
import ai.libs.jaicore.ml.interfaces.LabeledInstances;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.reflect.MethodUtils;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.MultipleClassifiersCombiner;
import weka.classifiers.SingleClassifierEnhancer;
import weka.classifiers.functions.SMO;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.InstanceComparator;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.json.JSONInstances;
import weka.core.json.JSONNode;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class WekaUtil {
    public static Collection<String> getBasicLearners() {
        ArrayList<String> classifiers = new ArrayList<String>();
        classifiers.add("weka.classifiers.bayes.BayesNet");
        classifiers.add("weka.classifiers.bayes.NaiveBayes");
        classifiers.add("weka.classifiers.bayes.NaiveBayesMultinomial");
        classifiers.add("weka.classifiers.functions.Logistic");
        classifiers.add("weka.classifiers.functions.MultilayerPerceptron");
        classifiers.add("weka.classifiers.functions.SimpleLinearRegression");
        classifiers.add("weka.classifiers.functions.SimpleLogistic");
        classifiers.add("weka.classifiers.functions.SMO");
        classifiers.add("weka.classifiers.functions.VotedPerceptron");
        classifiers.add("weka.classifiers.lazy.IBk");
        classifiers.add("weka.classifiers.lazy.KStar");
        classifiers.add("weka.classifiers.rules.JRip");
        classifiers.add("weka.classifiers.rules.M5Rules");
        classifiers.add("weka.classifiers.rules.OneR");
        classifiers.add("weka.classifiers.rules.PART");
        classifiers.add("weka.classifiers.rules.ZeroR");
        classifiers.add("weka.classifiers.trees.DecisionStump");
        classifiers.add("weka.classifiers.trees.J48");
        classifiers.add("weka.classifiers.trees.LMT");
        classifiers.add("weka.classifiers.trees.M5P");
        classifiers.add("weka.classifiers.trees.RandomForest");
        classifiers.add("weka.classifiers.trees.RandomTree");
        classifiers.add("weka.classifiers.trees.REPTree");
        return classifiers;
    }

    public static Collection<String> getNativeMultiClassClassifiers() {
        ArrayList<String> classifiers = new ArrayList<String>();
        classifiers.add("weka.classifiers.bayes.BayesNet");
        classifiers.add("weka.classifiers.bayes.NaiveBayes");
        classifiers.add("weka.classifiers.bayes.NaiveBayesMultinomial");
        classifiers.add("weka.classifiers.functions.Logistic");
        classifiers.add("weka.classifiers.functions.MultilayerPerceptron");
        classifiers.add("weka.classifiers.functions.SimpleLogistic");
        classifiers.add("weka.classifiers.lazy.IBk");
        classifiers.add("weka.classifiers.lazy.KStar");
        classifiers.add("weka.classifiers.rules.JRip");
        classifiers.add("weka.classifiers.rules.M5Rules");
        classifiers.add("weka.classifiers.rules.OneR");
        classifiers.add("weka.classifiers.rules.PART");
        classifiers.add("weka.classifiers.rules.ZeroR");
        classifiers.add("weka.classifiers.trees.DecisionStump");
        classifiers.add("weka.classifiers.trees.J48");
        classifiers.add("weka.classifiers.trees.LMT");
        classifiers.add("weka.classifiers.trees.M5P");
        classifiers.add("weka.classifiers.trees.RandomForest");
        classifiers.add("weka.classifiers.trees.RandomTree");
        classifiers.add("weka.classifiers.trees.REPTree");
        return classifiers;
    }

    public static Collection<String> getBinaryClassifiers() {
        ArrayList<String> classifiers = new ArrayList<String>();
        classifiers.add("weka.classifiers.functions.SMO");
        classifiers.add("weka.classifiers.functions.VotedPerceptron");
        return classifiers;
    }

    public static Collection<String> getFeatureEvaluators() {
        ArrayList<String> preprocessors = new ArrayList<String>();
        preprocessors.add("weka.attributeSelection.CfsSubsetEval");
        preprocessors.add("weka.attributeSelection.CorrelationAttributeEval");
        preprocessors.add("weka.attributeSelection.GainRatioAttributeEval");
        preprocessors.add("weka.attributeSelection.InfoGainAttributeEval");
        preprocessors.add("weka.attributeSelection.OneRAttributeEval");
        preprocessors.add("weka.attributeSelection.PrincipalComponents");
        preprocessors.add("weka.attributeSelection.ReliefFAttributeEval");
        preprocessors.add("weka.attributeSelection.SymmetricalUncertAttributeEval");
        return preprocessors;
    }

    public static Collection<String> getSearchers() {
        ArrayList<String> preprocessors = new ArrayList<String>();
        preprocessors.add("weka.attributeSelection.Ranker");
        preprocessors.add("weka.attributeSelection.BestFirst");
        preprocessors.add("weka.attributeSelection.GreedyStepwise");
        return preprocessors;
    }

    public static Collection<String> getMetaLearners() {
        ArrayList<String> classifiers = new ArrayList<String>();
        classifiers.add("weka.classifiers.meta.AdaBoostM1");
        classifiers.add("weka.classifiers.meta.AdditiveRegression");
        classifiers.add("weka.classifiers.meta.AttributeSelectedClassifier");
        classifiers.add("weka.classifiers.meta.Bagging");
        classifiers.add("weka.classifiers.meta.ClassificationViaRegression");
        classifiers.add("weka.classifiers.meta.LogitBoost");
        classifiers.add("weka.classifiers.meta.MultiClassClassifier");
        classifiers.add("weka.classifiers.meta.RandomCommittee");
        classifiers.add("weka.classifiers.meta.RandomSubspace");
        classifiers.add("weka.classifiers.meta.Stacking");
        classifiers.add("weka.classifiers.meta.Vote");
        return classifiers;
    }

    public static boolean isValidPreprocessorCombination(String searcher, String evaluator) {
        boolean isSetEvaluator = evaluator.toLowerCase().matches(".*(relief|gainratio|principalcomponents|onerattributeeval|infogainattributeeval|correlationattributeeval|symmetricaluncertattributeeval).*");
        boolean isRanker = searcher.toLowerCase().contains("ranker");
        boolean isNonRankerEvaluator = evaluator.toLowerCase().matches(".*(cfssubseteval).*");
        return !(isSetEvaluator && !isRanker || isNonRankerEvaluator && isRanker);
    }

    public static Collection<List<String>> getAdmissibleSearcherEvaluatorCombinationsForAttributeSelection() {
        ArrayList<List<String>> preprocessors = new ArrayList<List<String>>();
        ArrayList<Collection<String>> sets = new ArrayList<Collection<String>>();
        try {
            sets.add(WekaUtil.getSearchers());
            sets.add(WekaUtil.getFeatureEvaluators());
            CartesianProductComputationProblem problem = new CartesianProductComputationProblem(sets);
            List combinations = new LDSRelationComputer((RelationComputationProblem)problem).call();
            for (List combo : combinations) {
                if (!WekaUtil.isValidPreprocessorCombination((String)combo.get(0), (String)combo.get(1))) continue;
                preprocessors.add(combo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return preprocessors;
    }

    public static <L> weka.core.Instances fromJAICoreInstances(WekaCompatibleInstancesImpl instances) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        int numAttributes = instances.getNumberOfColumns();
        System.out.println(numAttributes);
        for (int i = 1; i <= numAttributes; ++i) {
            attributes.add(new Attribute("a" + i));
        }
        HashMap<String, Double> labelMap = new HashMap<String, Double>();
        int c = 0;
        boolean isNominal = false;
        for (String o : instances.getDeclaredClasses()) {
            labelMap.put(o, Double.valueOf(c++));
            if (Double.class.isInstance(o)) continue;
            isNominal = true;
        }
        if (isNominal) {
            attributes.add(new Attribute("label", instances.getDeclaredClasses()));
        } else {
            attributes.add(new Attribute("label"));
        }
        weka.core.Instances wekaInstances = new weka.core.Instances("JAICore-extracted dataset", attributes, instances.size());
        wekaInstances.setClassIndex(numAttributes);
        for (Instance instance : instances) {
            DenseInstance wekaInstance = new DenseInstance(numAttributes + 1);
            wekaInstance.setDataset(wekaInstances);
            int att = 0;
            for (Double val : instance) {
                wekaInstance.setValue(att++, val.doubleValue());
            }
            wekaInstance.setClassValue(((Double)labelMap.get(((LabeledInstance)instance).getLabel())).doubleValue());
            wekaInstances.add((weka.core.Instance)wekaInstance);
        }
        return wekaInstances;
    }

    public static weka.core.Instances fromJAICoreInstances(Instances instances) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        int numAttributes = instances.getNumberOfColumns();
        for (int i = 1; i <= numAttributes; ++i) {
            attributes.add(new Attribute("a" + i));
        }
        weka.core.Instances wekaInstances = new weka.core.Instances("JAICore-extracted dataset", attributes, 0);
        for (Instance instance : instances) {
            wekaInstances.add(WekaUtil.fromJAICoreInstance(instance));
        }
        return wekaInstances;
    }

    public static weka.core.Instances getEmptyDatasetForJAICoreInstance(Instance instance) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        int numAttributes = instance.getNumberOfColumns();
        for (int i = 1; i <= numAttributes; ++i) {
            attributes.add(new Attribute("a" + i));
        }
        return new weka.core.Instances("JAICore-extracted dataset", attributes, 0);
    }

    public static weka.core.Instance fromJAICoreInstance(Instance instance) {
        weka.core.Instances emptyDataset = WekaUtil.getEmptyDatasetForJAICoreInstance(instance);
        DenseInstance wekaInstance = new DenseInstance(instance.getNumberOfColumns());
        int att = 0;
        for (Double val : instance) {
            wekaInstance.setValue(att++, val.doubleValue());
        }
        emptyDataset.add((weka.core.Instance)wekaInstance);
        return (weka.core.Instance)emptyDataset.iterator().next();
    }

    public static weka.core.Instance fromJAICoreInstance(LabeledInstance<String> instance) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        int numAttributes = instance.getNumberOfColumns();
        for (int i = 1; i <= numAttributes; ++i) {
            attributes.add(new Attribute("a" + i));
        }
        ArrayList<String> possibleValues = new ArrayList<String>();
        possibleValues.add(instance.getLabel());
        Attribute classAttribute = new Attribute("label", possibleValues);
        attributes.add(classAttribute);
        weka.core.Instances instances = new weka.core.Instances("JAICore-extracted dataset", attributes, 1);
        instances.setClassIndex(attributes.size() - 1);
        double[] values = new double[numAttributes + 1];
        for (int i = 0; i < numAttributes; ++i) {
            values[i] = (Double)instance.get(i);
        }
        DenseInstance inst = new DenseInstance(1.0, values);
        instances.add((weka.core.Instance)inst);
        weka.core.Instance addedInstance = instances.get(0);
        addedInstance.setClassValue(instance.getLabel());
        return addedInstance;
    }

    public static weka.core.Instances fromJAICoreInstances(LabeledInstances<String> labeledInstances) {
        int attributeCount = labeledInstances.getNumberOfColumns() + 1;
        int dataSize = labeledInstances.getNumberOfRows();
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>(attributeCount);
        for (int i = 1; i < attributeCount; ++i) {
            attributeList.add(new Attribute("a" + i));
        }
        ArrayList<String> classes = labeledInstances.getOccurringLabels();
        Attribute classAttribute = new Attribute("label", classes);
        attributeList.add(classAttribute);
        weka.core.Instances wekaInstances = new weka.core.Instances("JAICore-extracted dataset", attributeList, dataSize);
        wekaInstances.setClassIndex(wekaInstances.numAttributes() - 1);
        for (LabeledInstance labeledInstance : labeledInstances) {
            double[] values = new double[attributeCount];
            for (int i = 0; i < attributeCount - 1; ++i) {
                values[i] = (Double)labeledInstance.get(i);
            }
            DenseInstance wekaInstance = new DenseInstance(1.0, values);
            String label = (String)labeledInstance.getLabel();
            wekaInstance.setDataset(wekaInstances);
            double classIndex = classAttribute.indexOfValue(label);
            wekaInstance.setClassValue(classIndex);
            wekaInstances.add((weka.core.Instance)wekaInstance);
        }
        return wekaInstances;
    }

    public static WekaCompatibleInstancesImpl toJAICoreLabeledInstances(weka.core.Instances wekaInstances) {
        WekaCompatibleInstancesImpl labeledInstances = new WekaCompatibleInstancesImpl(WekaUtil.getClassesDeclaredInDataset(wekaInstances));
        for (weka.core.Instance inst : wekaInstances) {
            labeledInstances.add(WekaUtil.toJAICoreLabeledInstance(inst));
        }
        return labeledInstances;
    }

    public static boolean needsBinarization(weka.core.Instances wekaInstances, boolean ignoreClassAttribute) {
        Attribute classAttribute = wekaInstances.classAttribute();
        if (!ignoreClassAttribute && classAttribute.isNominal() && classAttribute.numValues() >= 3) {
            return true;
        }
        Enumeration attributeEnum = wekaInstances.enumerateAttributes();
        while (attributeEnum.hasMoreElements()) {
            Attribute currentAttr = (Attribute)attributeEnum.nextElement();
            if (!currentAttr.isNominal() || currentAttr == classAttribute || currentAttr.numValues() < 3) continue;
            return true;
        }
        return false;
    }

    public static LabeledInstance<String> toJAICoreLabeledInstance(weka.core.Instance wekaInst) {
        SimpleLabeledInstanceImpl inst = new SimpleLabeledInstanceImpl();
        for (int att = 0; att < wekaInst.numAttributes(); ++att) {
            if (att == wekaInst.classIndex()) continue;
            inst.add(wekaInst.value(att));
        }
        inst.setLabel(wekaInst.classAttribute().value((int)wekaInst.classValue()));
        return inst;
    }

    public static Instances toJAICoreInstances(weka.core.Instances wekaInstances) {
        SimpleInstancesImpl instances = new SimpleInstancesImpl(wekaInstances.size());
        for (weka.core.Instance inst : wekaInstances) {
            instances.add(new SimpleInstanceImpl(inst.toDoubleArray()));
        }
        return instances;
    }

    public static Collection<String> getPossibleClassValues(weka.core.Instance instance) {
        ArrayList<String> labels = new ArrayList<String>();
        Attribute classAttr = instance.classAttribute();
        for (int i = 0; i < classAttr.numValues(); ++i) {
            labels.add(classAttr.value(i));
        }
        return labels;
    }

    public static Instance toJAICoreInstance(weka.core.Instance wekaInst) {
        SimpleInstanceImpl inst = new SimpleInstanceImpl();
        for (int att = 0; att < wekaInst.numAttributes(); ++att) {
            inst.add(wekaInst.value(att));
        }
        return inst;
    }

    public static String getClassifierDescriptor(Classifier c) {
        StringBuilder sb = new StringBuilder();
        sb.append(c.getClass().getName());
        if (c instanceof OptionHandler) {
            sb.append("- [");
            int i = 0;
            for (String s : ((OptionHandler)c).getOptions()) {
                if (i++ > 0) {
                    sb.append(", ");
                }
                sb.append(s);
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public static Collection<Option> getOptionsOfWekaAlgorithm(Object o) {
        ArrayList<Option> options = new ArrayList<Option>();
        if (!(o instanceof OptionHandler)) {
            return options;
        }
        OptionHandler oh = (OptionHandler)o;
        Enumeration optionEnum = oh.listOptions();
        while (optionEnum.hasMoreElements()) {
            options.add((Option)optionEnum.nextElement());
        }
        return options;
    }

    public static List<String> getClassNames(weka.core.Instance instance) {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration namesEnumration = instance.classAttribute().enumerateValues();
        while (namesEnumration.hasMoreElements()) {
            names.add((String)namesEnumration.nextElement());
        }
        return names;
    }

    public static Map<String, Integer> getClassNameToIDMap(weka.core.Instance instance) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List<String> classNames = WekaUtil.getClassNames(instance);
        for (int i = 0; i < classNames.size(); ++i) {
            map.put(classNames.get(i), i);
        }
        return map;
    }

    public static int getIntValOfClassName(weka.core.Instance instance, String className) {
        Map<String, Integer> map = WekaUtil.getClassNameToIDMap(instance);
        return map.containsKey(className) ? map.get(className) : -1;
    }

    public static void printClassSplitAssignments(List<weka.core.Instances> split) {
        int sum = 0;
        StringBuilder sb = new StringBuilder();
        Map<String, weka.core.Instances> firstSet = WekaUtil.getInstancesPerClass(split.get(0));
        for (String cl : firstSet.keySet()) {
            sb.append(cl);
            sb.append(": ");
            int i = 0;
            for (weka.core.Instances set : split) {
                Map<String, weka.core.Instances> map = WekaUtil.getInstancesPerClass(set);
                sb.append(map.containsKey(cl) ? map.get(cl).size() : 0);
                sum += map.containsKey(cl) ? map.get(cl).size() : 0;
                if (i >= split.size() - 1) continue;
                sb.append("/");
                ++i;
            }
            sb.append("\n");
        }
        System.out.println(sb.toString());
        System.out.println("Total: " + sum);
    }

    public static weka.core.Instances getInstancesOfClass(weka.core.Instances data, Collection<String> classNames) {
        weka.core.Instances newInstances = new weka.core.Instances(data);
        newInstances.removeIf(i -> !classNames.contains(WekaUtil.getClassName(i)));
        return newInstances;
    }

    public static weka.core.Instances getInstancesOfClass(weka.core.Instances data, String className) {
        weka.core.Instances newInstances = new weka.core.Instances(data);
        newInstances.removeIf(i -> !WekaUtil.getClassName(i).equals(className));
        return newInstances;
    }

    public static String getClassName(weka.core.Instance instance) {
        return WekaUtil.getClassNames(instance).get((int)instance.classValue());
    }

    public static Map<String, weka.core.Instances> getInstancesPerClass(weka.core.Instances data) {
        weka.core.Instances emptyInstances = new weka.core.Instances(data);
        emptyInstances.clear();
        HashMap<String, weka.core.Instances> classWiseSeparation = new HashMap<String, weka.core.Instances>();
        for (weka.core.Instance i : data) {
            String assignedClass = data.classAttribute().value((int)i.classValue());
            if (!classWiseSeparation.containsKey(assignedClass)) {
                weka.core.Instances inst = new weka.core.Instances(emptyInstances);
                classWiseSeparation.put(assignedClass, inst);
            }
            ((weka.core.Instances)classWiseSeparation.get(assignedClass)).add(i);
        }
        return classWiseSeparation;
    }

    public static Map<String, Integer> getNumberOfInstancesPerClass(weka.core.Instances data) {
        Map<String, weka.core.Instances> instancesPerClass = WekaUtil.getInstancesPerClass(data);
        HashMap<String, Integer> counter = new HashMap<String, Integer>();
        for (String key : instancesPerClass.keySet()) {
            counter.put(key, instancesPerClass.get(key).size());
        }
        return counter;
    }

    public static int getNumberOfInstancesFromClass(weka.core.Instances data, String c) {
        return WekaUtil.getInstancesOfClass(data, c).size();
    }

    public static int getNumberOfInstancesFromClass(weka.core.Instances data, Collection<String> cs) {
        Map<String, Integer> map = WekaUtil.getNumberOfInstancesPerClass(data);
        int sum = 0;
        for (String c : cs) {
            if (!map.containsKey(c)) continue;
            sum += map.get(c).intValue();
        }
        return sum;
    }

    public static double getRelativeNumberOfInstancesFromClass(weka.core.Instances data, String c) {
        if (data.size() == 0) {
            return 0.0;
        }
        return (float)WekaUtil.getNumberOfInstancesFromClass(data, c) / (1.0f * (float)data.size());
    }

    public static double getRelativeNumberOfInstancesFromClass(weka.core.Instances data, Collection<String> cs) {
        return (float)WekaUtil.getNumberOfInstancesFromClass(data, cs) / (1.0f * (float)data.size());
    }

    public static Collection<Integer>[] getArbitrarySplit(weka.core.Instances data, Random rand, double ... portions) {
        double sum = 0.0;
        for (double p : portions) {
            sum += p;
        }
        if (sum > 1.0) {
            throw new IllegalArgumentException("Portions must sum up to at most 1.");
        }
        LinkedList indices = new LinkedList(ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(data.size() - 1)), (DiscreteDomain)DiscreteDomain.integers()).asList());
        Collections.shuffle(indices, rand);
        ArrayList[] folds = new ArrayList[portions.length + 1];
        weka.core.Instances emptyInstances = new weka.core.Instances(data);
        emptyInstances.clear();
        for (int i = 0; i <= portions.length; ++i) {
            double portion = i < portions.length ? portions[i] : 1.0 - sum;
            int numberOfItems = (int)Math.floor((double)data.size() * portion);
            ArrayList fold = new ArrayList(numberOfItems);
            for (int j = 0; j < numberOfItems; ++j) {
                fold.add(indices.poll());
            }
            folds[i] = fold;
        }
        while (!indices.isEmpty()) {
            folds[rand.nextInt(folds.length)].add(indices.poll());
        }
        assert (Arrays.asList(folds).stream().mapToInt(l -> l.size()).sum() == data.size()) : "The number of instancens in the folds does not equal the number of instances in the original dataset";
        return folds;
    }

    public static List<weka.core.Instances> realizeSplit(weka.core.Instances data, Collection<Integer>[] split) {
        return WekaUtil.realizeSplitAsCopiedInstances(data, split);
    }

    public static List<weka.core.Instances> realizeSplit(weka.core.Instances data, List<List<Integer>> split) {
        return WekaUtil.realizeSplitAsCopiedInstances(data, split);
    }

    public static List<weka.core.Instances> realizeSplitAsCopiedInstances(weka.core.Instances data, List<List<Integer>> split) {
        ArrayList<weka.core.Instances> folds = new ArrayList<weka.core.Instances>();
        for (Collection collection : split) {
            weka.core.Instances fold = new weka.core.Instances(data, 0);
            collection.stream().forEach(i -> fold.add(data.get(i.intValue())));
            folds.add(fold);
        }
        return folds;
    }

    public static List<weka.core.Instances> realizeSplitAsCopiedInstances(weka.core.Instances data, Collection<Integer>[] split) {
        ArrayList<weka.core.Instances> folds = new ArrayList<weka.core.Instances>();
        for (Collection<Integer> foldIndices : split) {
            weka.core.Instances fold = new weka.core.Instances(data, 0);
            foldIndices.stream().forEach(i -> fold.add(data.get(i.intValue())));
            folds.add(fold);
        }
        return folds;
    }

    public static List<weka.core.Instances> realizeSplitAsSubInstances(weka.core.Instances data, Collection<Integer>[] split) {
        ArrayList<weka.core.Instances> folds = new ArrayList<weka.core.Instances>();
        for (Collection<Integer> foldIndices : split) {
            int[] indices = new int[foldIndices.size()];
            int i = 0;
            for (Integer x : foldIndices) {
                indices[i++] = x;
            }
            folds.add(new SubInstances(data, indices));
        }
        return folds;
    }

    public static Collection<Integer>[] getStratifiedSplitIndices(weka.core.Instances data, Random rand, double ... pPortions) {
        double sum = 0.0;
        double[] portions = new double[pPortions.length + 1];
        for (int i = 0; i < pPortions.length; ++i) {
            sum += pPortions[i];
            portions[i] = pPortions[i];
        }
        if (sum > 1.0) {
            throw new IllegalArgumentException("Portions must sum up to at most 1.");
        }
        portions[pPortions.length] = 1.0 - sum;
        Map<String, Integer> numberOfInstancesPerClass = WekaUtil.getNumberOfInstancesPerClass(data);
        HashMap numberOfInstancesPerClassAndFold = new HashMap();
        for (String className : numberOfInstancesPerClass.keySet()) {
            numberOfInstancesPerClassAndFold.put(className, new HashMap());
            for (int foldId = 0; foldId < portions.length; ++foldId) {
                ((Map)numberOfInstancesPerClassAndFold.get(className)).put(foldId, (int)Math.ceil((double)numberOfInstancesPerClass.get(className).intValue() * portions[foldId]) + 1);
            }
        }
        HashMap<String, Integer> nextBinForClass = new HashMap<String, Integer>();
        numberOfInstancesPerClass.keySet().forEach(c -> nextBinForClass.put((String)c, 0));
        ArrayList[] folds = new ArrayList[portions.length];
        LinkedList indices = new LinkedList(ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(data.size() - 1)), (DiscreteDomain)DiscreteDomain.integers()).asList());
        Collections.shuffle(indices, rand);
        while (!indices.isEmpty()) {
            int index = (Integer)indices.poll();
            String assignedClass = WekaUtil.getClassName(data.get(index));
            int foldId = (Integer)nextBinForClass.get(assignedClass);
            if (folds[foldId] == null) {
                folds[foldId] = new ArrayList();
            }
            ArrayList fold = folds[foldId];
            fold.add(index);
            ((Map)numberOfInstancesPerClassAndFold.get(assignedClass)).put(foldId, (Integer)((Map)numberOfInstancesPerClassAndFold.get(assignedClass)).get(foldId) - 1);
            do {
                if (++foldId < portions.length) continue;
                foldId = 0;
            } while ((Integer)((Map)numberOfInstancesPerClassAndFold.get(assignedClass)).get(foldId) <= 0);
            nextBinForClass.put(assignedClass, foldId);
        }
        assert (Arrays.asList(folds).stream().mapToInt(l -> l.size()).sum() == data.size()) : "The number of instancens in the folds does not equal the number of instances in the original dataset";
        return folds;
    }

    public static List<List<Integer>> getStratifiedSplitIndicesAsList(weka.core.Instances data, Random rand, double ... portions) {
        int i;
        double sum = 0.0;
        for (double p : portions) {
            sum += p;
        }
        if (sum > 1.0) {
            throw new IllegalArgumentException("Portions must sum up to at most 1.");
        }
        weka.core.Instances shuffledData = new weka.core.Instances(data);
        shuffledData.randomize(rand);
        ArrayList<List<Integer>> instances = new ArrayList<List<Integer>>();
        weka.core.Instances emptyInstances = new weka.core.Instances(shuffledData);
        emptyInstances.clear();
        HashMap classWiseSeparation = new HashMap();
        for (int i2 = 0; i2 < data.size(); ++i2) {
            String assignedClass = data.classAttribute().value((int)data.get(i2).classValue());
            if (!classWiseSeparation.containsKey(assignedClass)) {
                classWiseSeparation.put(assignedClass, new LinkedList());
            }
            ((List)classWiseSeparation.get(assignedClass)).add(i2);
        }
        HashMap<String, Integer> classCapacities = new HashMap<String, Integer>();
        for (String c : classWiseSeparation.keySet()) {
            classCapacities.put(c, ((List)classWiseSeparation.get(c)).size());
        }
        for (i = 0; i <= portions.length; ++i) {
            LinkedList instancesForSplit = new LinkedList();
            for (String c : classWiseSeparation.keySet()) {
                List availableInstances = (List)classWiseSeparation.get(c);
                if (availableInstances.isEmpty()) continue;
                instancesForSplit.add(availableInstances.get(0));
                availableInstances.remove(0);
            }
            instances.add(instancesForSplit);
        }
        for (i = 0; i <= portions.length; ++i) {
            double portion = i < portions.length ? portions[i] : 1.0 - sum;
            List instancesForSplit = (List)instances.get(i);
            for (String c : classWiseSeparation.keySet()) {
                List availableInstances = (List)classWiseSeparation.get(c);
                int items = (int)Math.min((double)availableInstances.size(), Math.ceil(portion * (double)((Integer)classCapacities.get(c)).intValue()));
                for (int j = 0; j < items; ++j) {
                    instancesForSplit.add(availableInstances.get(0));
                    availableInstances.remove(0);
                }
            }
            Collections.shuffle(instancesForSplit, rand);
        }
        assert (instances.stream().mapToInt(l -> l.size()).sum() == data.size()) : "The number of instances in the folds does not equal the number of instances in the original dataset";
        return instances;
    }

    public static ArrayNode splitToJsonArray(Collection<Integer>[] splitDecision) {
        ObjectMapper om = new ObjectMapper();
        ArrayNode an = om.createArrayNode();
        splitDecision[0].stream().sorted().forEach(v -> an.add(v));
        return an;
    }

    public static List<weka.core.Instances> getStratifiedSplit(weka.core.Instances data, long seed, double ... portions) {
        int i;
        if (data instanceof ReproducibleInstances) {
            List<ReproducibleInstances> reproducibleInstancesResult = WekaUtil.getStratifiedSplit((ReproducibleInstances)data, seed, portions);
            ArrayList<weka.core.Instances> result = new ArrayList<weka.core.Instances>(reproducibleInstancesResult.size());
            for (int i2 = 0; i2 < reproducibleInstancesResult.size(); ++i2) {
                result.add(reproducibleInstancesResult.get(i2));
            }
            return result;
        }
        Random rand = new Random(seed);
        double sum = 0.0;
        for (double p : portions) {
            sum += p;
        }
        if (sum > 1.0) {
            throw new IllegalArgumentException("Portions must sum up to at most 1.");
        }
        weka.core.Instances shuffledData = new weka.core.Instances(data);
        shuffledData.randomize(rand);
        ArrayList<weka.core.Instances> instances = new ArrayList<weka.core.Instances>();
        weka.core.Instances emptyInstances = new weka.core.Instances(shuffledData);
        emptyInstances.clear();
        Map<String, weka.core.Instances> classWiseSeparation = WekaUtil.getInstancesPerClass(shuffledData);
        HashMap<String, Integer> classCapacities = new HashMap<String, Integer>(classWiseSeparation.size());
        for (String c : classWiseSeparation.keySet()) {
            classCapacities.put(c, classWiseSeparation.get(c).size());
        }
        for (i = 0; i <= portions.length; ++i) {
            weka.core.Instances instancesForSplit = new weka.core.Instances(emptyInstances);
            for (String c : classWiseSeparation.keySet()) {
                weka.core.Instances availableInstances = classWiseSeparation.get(c);
                if (availableInstances.isEmpty()) continue;
                instancesForSplit.add(availableInstances.get(0));
                availableInstances.remove(0);
            }
            instances.add(instancesForSplit);
        }
        for (i = 0; i <= portions.length; ++i) {
            double portion = i < portions.length ? portions[i] : 1.0 - sum;
            weka.core.Instances instancesForSplit = (weka.core.Instances)instances.get(i);
            for (String c : classWiseSeparation.keySet()) {
                weka.core.Instances availableInstances = classWiseSeparation.get(c);
                int items = (int)Math.min((double)availableInstances.size(), Math.ceil(portion * (double)((Integer)classCapacities.get(c)).intValue()));
                for (int j = 0; j < items; ++j) {
                    instancesForSplit.add(availableInstances.get(0));
                    availableInstances.remove(0);
                }
            }
            instancesForSplit.randomize(rand);
        }
        assert (instances.stream().mapToInt(l -> l.size()).sum() == data.size()) : "The number of instances in the folds does not equal the number of instances in the original dataset";
        return instances;
    }

    public static List<ReproducibleInstances> getStratifiedSplit(ReproducibleInstances data, Random rand, double ... portions) {
        return WekaUtil.getStratifiedSplit(data, rand.nextLong(), portions);
    }

    public static List<ReproducibleInstances> getStratifiedSplit(ReproducibleInstances data, long seed, double ... portions) {
        int i;
        Random rand = new Random(seed);
        double sum = 0.0;
        for (double p : portions) {
            sum += p;
        }
        if (sum > 1.0) {
            throw new IllegalArgumentException("Portions must sum up to at most 1.");
        }
        weka.core.Instances shuffledData = new weka.core.Instances((weka.core.Instances)data);
        shuffledData.randomize(rand);
        ArrayList<ReproducibleInstances> instances = new ArrayList<ReproducibleInstances>();
        ReproducibleInstances emptyInstances = new ReproducibleInstances(data);
        emptyInstances.clear();
        Map<String, weka.core.Instances> classWiseSeparation = WekaUtil.getInstancesPerClass(shuffledData);
        HashMap<String, Integer> classCapacities = new HashMap<String, Integer>(classWiseSeparation.size());
        for (String c : classWiseSeparation.keySet()) {
            classCapacities.put(c, classWiseSeparation.get(c).size());
        }
        for (i = 0; i <= portions.length; ++i) {
            ReproducibleInstances instancesForSplit = new ReproducibleInstances(emptyInstances);
            for (String c : classWiseSeparation.keySet()) {
                weka.core.Instances availableInstances = classWiseSeparation.get(c);
                if (availableInstances.isEmpty()) continue;
                instancesForSplit.add(availableInstances.get(0));
                availableInstances.remove(0);
            }
            instances.add(instancesForSplit);
        }
        for (i = 0; i <= portions.length; ++i) {
            double portion = i < portions.length ? portions[i] : 1.0 - sum;
            ReproducibleInstances instancesForSplit = (ReproducibleInstances)((Object)instances.get(i));
            for (String c : classWiseSeparation.keySet()) {
                weka.core.Instances availableInstances = classWiseSeparation.get(c);
                int items = (int)Math.min((double)availableInstances.size(), Math.ceil(portion * (double)((Integer)classCapacities.get(c)).intValue()));
                for (int j = 0; j < items; ++j) {
                    instancesForSplit.add(availableInstances.get(0));
                    availableInstances.remove(0);
                }
            }
            instancesForSplit.randomize(rand);
        }
        assert (instances.stream().mapToInt(l -> l.size()).sum() == data.size()) : "The number of instances in the folds does not equal the number of instances in the original dataset";
        String ratiosAsString = Arrays.toString(portions);
        for (int i2 = 0; i2 < instances.size(); ++i2) {
            ((ReproducibleInstances)((Object)instances.get(i2))).addInstruction(new SplitInstruction(ratiosAsString, seed, i2));
        }
        return instances;
    }

    public static List<File> getDatasetsInFolder(File folder) throws IOException {
        ArrayList files = new ArrayList();
        try (Stream<Path> paths = Files.walk(folder.toPath(), new FileVisitOption[0]);){
            paths.filter(f -> f.getParent().toFile().equals(folder) && f.toFile().getAbsolutePath().endsWith(".arff")).forEach(f -> files.add(f.toFile()));
        }
        return files.stream().sorted().collect(Collectors.toList());
    }

    public static weka.core.Instances getRefactoredInstances(weka.core.Instances data, Map<String, String> classMap) {
        ArrayList<String> targetClasses = new ArrayList<String>(new HashSet<String>(classMap.values()));
        weka.core.Instances childData = WekaUtil.getEmptySetOfInstancesWithRefactoredClass(data, targetClasses);
        for (weka.core.Instance i : data) {
            String className = i.classAttribute().value((int)Math.round(i.classValue()));
            if (!classMap.containsKey(className)) continue;
            weka.core.Instance iNew = WekaUtil.getRefactoredInstance(i, targetClasses);
            iNew.setClassValue(classMap.get(className));
            iNew.setDataset(childData);
            childData.add(iNew);
        }
        return childData;
    }

    public static weka.core.Instance getRefactoredInstance(weka.core.Instance instance) {
        weka.core.Instances dataset = WekaUtil.getEmptySetOfInstancesWithRefactoredClass(instance.dataset());
        int numAttributes = instance.numAttributes();
        int classIndex = instance.classIndex();
        DenseInstance iNew = new DenseInstance(numAttributes);
        for (int i = 0; i < numAttributes; ++i) {
            Attribute a = instance.attribute(i);
            if (i != classIndex) {
                iNew.setValue(a, instance.value(a));
                continue;
            }
            iNew.setValue(a, 0.0);
        }
        dataset.add((weka.core.Instance)iNew);
        iNew.setDataset(dataset);
        return iNew;
    }

    public static weka.core.Instance getRefactoredInstance(weka.core.Instance instance, List<String> classes) {
        weka.core.Instances dataset = WekaUtil.getEmptySetOfInstancesWithRefactoredClass(instance.dataset(), classes);
        int numAttributes = instance.numAttributes();
        int classIndex = instance.classIndex();
        DenseInstance iNew = new DenseInstance(numAttributes);
        for (int i = 0; i < numAttributes; ++i) {
            Attribute a = instance.attribute(i);
            if (i != classIndex) {
                iNew.setValue(a, instance.value(a));
                continue;
            }
            iNew.setValue(a, 0.0);
        }
        dataset.add((weka.core.Instance)iNew);
        iNew.setDataset(dataset);
        return iNew;
    }

    public static weka.core.Instances getEmptySetOfInstancesWithRefactoredClass(weka.core.Instances instances) {
        List<Attribute> newAttributes = WekaUtil.getAttributes(instances, false);
        newAttributes.add(instances.classIndex(), WekaUtil.getNewClassAttribute(instances.classAttribute()));
        weka.core.Instances newData = new weka.core.Instances("split", (ArrayList)newAttributes, 0);
        newData.setClassIndex(instances.classIndex());
        return newData;
    }

    public static weka.core.Instances getEmptySetOfInstancesWithRefactoredClass(weka.core.Instances instances, List<String> classes) {
        List<Attribute> newAttributes = WekaUtil.getAttributes(instances, false);
        newAttributes.add(instances.classIndex(), WekaUtil.getNewClassAttribute(instances.classAttribute(), classes));
        weka.core.Instances newData = new weka.core.Instances("split", (ArrayList)newAttributes, 0);
        newData.setClassIndex(instances.classIndex());
        return newData;
    }

    public static List<Attribute> getAttributes(weka.core.Instances inst, boolean includeClassAttribute) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Enumeration e = inst.enumerateAttributes();
        while (e.hasMoreElements()) {
            attributes.add((Attribute)e.nextElement());
        }
        if (includeClassAttribute) {
            attributes.add(inst.classAttribute());
        }
        return attributes;
    }

    public static List<Attribute> getAttributes(weka.core.Instance inst) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Enumeration e = inst.enumerateAttributes();
        while (e.hasMoreElements()) {
            attributes.add((Attribute)e.nextElement());
        }
        return attributes;
    }

    public static boolean hasOnlyNumericAttributes(weka.core.Instances instances) {
        for (Attribute a : WekaUtil.getAttributes(instances, false)) {
            if (a.isNumeric()) continue;
            return false;
        }
        return true;
    }

    public static Attribute getNewClassAttribute(Attribute attribute) {
        List<String> vals = Arrays.asList("0.0", "1.0");
        Attribute a = new Attribute(attribute.name(), vals);
        return a;
    }

    public static Attribute getNewClassAttribute(Attribute attribute, List<String> classes) {
        Attribute a = new Attribute(attribute.name(), classes);
        return a;
    }

    public static List<Attribute> getReplacedAttributeList(List<Attribute> attributes, Attribute classAttribute) {
        ArrayList<Attribute> newAttributes = new ArrayList<Attribute>();
        for (Attribute a : attributes) {
            if (classAttribute != a) {
                newAttributes.add(a);
                continue;
            }
            newAttributes.add(WekaUtil.getNewClassAttribute(classAttribute));
        }
        return newAttributes;
    }

    public static weka.core.Instances mergeClassesOfInstances(weka.core.Instances data, Collection<String> cluster1, Collection<String> cluster2) {
        weka.core.Instances newData = WekaUtil.getEmptySetOfInstancesWithRefactoredClass(data);
        for (weka.core.Instance i : data) {
            weka.core.Instance iNew = (weka.core.Instance)i.copy();
            String className = i.classAttribute().value((int)Math.round(i.classValue()));
            if (cluster1.contains(className)) {
                iNew.setClassValue(0.0);
                newData.add(iNew);
                continue;
            }
            if (!cluster2.contains(className)) continue;
            iNew.setClassValue(1.0);
            newData.add(iNew);
        }
        return newData;
    }

    public static weka.core.Instances mergeClassesOfInstances(weka.core.Instances data, List<Set<String>> instancesCluster) {
        LinkedList<String> classes = new LinkedList<String>();
        IntStream.range(0, instancesCluster.size()).forEach(x -> classes.add("C" + (double)x));
        weka.core.Instances newData = WekaUtil.getEmptySetOfInstancesWithRefactoredClass(data, classes);
        for (weka.core.Instance i : data) {
            weka.core.Instance iNew = (weka.core.Instance)i.copy();
            String className = i.classAttribute().value((int)Math.round(i.classValue()));
            for (Set<String> cluster : instancesCluster) {
                if (!cluster.contains(className)) continue;
                iNew.setClassValue((double)instancesCluster.indexOf(cluster));
                iNew.setDataset(newData);
                newData.add(iNew);
            }
        }
        return newData;
    }

    public static List<String> getClassesDeclaredInDataset(weka.core.Instances data) {
        ArrayList<String> classes = new ArrayList<String>();
        Attribute classAttribute = data.classAttribute();
        for (int i = 0; i < classAttribute.numValues(); ++i) {
            classes.add(classAttribute.value(i));
        }
        return classes;
    }

    public static Collection<String> getClassesActuallyContainedInDataset(weka.core.Instances data) {
        Map<String, Integer> counter = WekaUtil.getNumberOfInstancesPerClass(data);
        return counter.keySet().stream().filter(k -> (Integer)counter.get(k) != 0).collect(Collectors.toList());
    }

    public static double[] getClassesAsArray(weka.core.Instances inst) {
        int n = inst.size();
        double[] vec = new double[n];
        for (int i = 0; i < n; ++i) {
            vec[i] = inst.get(i).classValue();
        }
        return vec;
    }

    public static List<Double> getClassesAsList(weka.core.Instances inst) {
        return inst.stream().map(weka.core.Instance::classValue).collect(Collectors.toList());
    }

    public static String instancesToJsonString(weka.core.Instances data) {
        StringBuilder sb = new StringBuilder();
        JSONNode json = JSONInstances.toJSON((weka.core.Instances)data);
        json.getChild("header").removeFromParent();
        StringBuffer buffer = new StringBuffer();
        json.toString(buffer);
        sb.append(buffer.toString());
        sb.append("\n");
        return sb.toString();
    }

    public static weka.core.Instances jsonStringToInstances(String json) {
        try {
            JSONNode node = JSONNode.read((Reader)new BufferedReader(new StringReader(json)));
            return JSONInstances.toInstances((JSONNode)node);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int[] getIndicesOfContainedInstances(weka.core.Instances dataset, weka.core.Instances subset) {
        int[] indices = new int[subset.size()];
        InstanceComparator comp = new InstanceComparator();
        for (int i = 0; i < indices.length; ++i) {
            weka.core.Instance inst = subset.get(i);
            int index = -1;
            for (int j = 0; j < dataset.size(); ++j) {
                if (comp.compare(inst, dataset.get(j)) != 0) continue;
                index = j;
                break;
            }
            if (index == -1) {
                throw new IllegalArgumentException("The instance " + inst + " is not contained in the given dataset.");
            }
            indices[i] = index;
        }
        return indices;
    }

    public static weka.core.Instance useFilterOnSingleInstance(weka.core.Instance instance, Filter filter) throws Exception {
        weka.core.Instances data = new weka.core.Instances(instance.dataset());
        data.clear();
        data.add(instance);
        weka.core.Instances filteredInstances = Filter.useFilter((weka.core.Instances)data, (Filter)filter);
        return filteredInstances.firstInstance();
    }

    public static weka.core.Instances removeClassAttribute(weka.core.Instances data) throws Exception {
        if (data.classIndex() < 0) {
            throw new IllegalArgumentException("Class index of data is not set!");
        }
        Remove remove = new Remove();
        remove.setAttributeIndices("" + (data.classIndex() + 1));
        remove.setInputFormat(data);
        weka.core.Instances reducedInstances = Filter.useFilter((weka.core.Instances)data, (Filter)remove);
        return reducedInstances;
    }

    public static weka.core.Instance removeClassAttribute(weka.core.Instance inst) throws Exception {
        Remove remove = new Remove();
        remove.setAttributeIndices("" + (inst.classIndex() + 1));
        remove.setInputFormat(inst.dataset());
        return WekaUtil.useFilterOnSingleInstance(inst, (Filter)remove);
    }

    public static Classifier cloneClassifier(Classifier c) throws Exception {
        Method cloneMethod = MethodUtils.getAccessibleMethod(c.getClass(), (String)"clone", (Class[])new Class[0]);
        if (cloneMethod != null) {
            return (Classifier)cloneMethod.invoke((Object)c, new Object[0]);
        }
        return AbstractClassifier.makeCopy((Classifier)c);
    }

    public static int[] getIndicesOfSubset(weka.core.Instances data, weka.core.Instances subset) {
        InstanceComparator comp = new InstanceComparator();
        ArrayList copy = new ArrayList(subset);
        int[] result = new int[subset.size()];
        int row = 0;
        int i = 0;
        for (weka.core.Instance ref : data) {
            for (int j = 0; j < copy.size(); ++j) {
                weka.core.Instance inst = (weka.core.Instance)copy.get(j);
                if (inst == null || comp.compare(inst, ref) != 0) continue;
                result[i++] = row;
                copy.remove(j--);
            }
            ++row;
            System.out.println(i + "/" + copy.size());
        }
        return result;
    }

    public static String printNestedWekaClassifier(Classifier c) {
        StringBuilder sb = new StringBuilder();
        sb.append(c.getClass().getName());
        sb.append("(");
        if (c instanceof SingleClassifierEnhancer) {
            sb.append(WekaUtil.printNestedWekaClassifier(((SingleClassifierEnhancer)c).getClassifier()));
        } else if (c instanceof SMO) {
            sb.append(((SMO)c).getKernel().getClass().getName());
        } else if (c instanceof MultipleClassifiersCombiner) {
            sb.append(WekaUtil.printNestedWekaClassifier(((MultipleClassifiersCombiner)c).getClassifier(0)));
        }
        sb.append(")");
        return sb.toString();
    }
}

