/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.cache;

import ai.libs.jaicore.ml.WekaUtil;
import ai.libs.jaicore.ml.cache.DataProvider;
import ai.libs.jaicore.ml.cache.Instruction;
import ai.libs.jaicore.ml.cache.LoadDataSetInstruction;
import ai.libs.jaicore.ml.openml.OpenMLHelper;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.InetAddress;
import java.util.LinkedList;
import java.util.List;
import weka.core.Instances;

public class ReproducibleInstances
extends Instances {
    private static final long serialVersionUID = 4318807226111536282L;
    private List<Instruction> history = new LinkedList<Instruction>();
    private boolean cacheStorage = true;
    private boolean cacheLookup = true;

    private ReproducibleInstances(Instances dataset) {
        super(dataset);
    }

    public static ReproducibleInstances fromHistory(List<Instruction> history, String apiKey) throws IOException {
        ReproducibleInstances instances = null;
        block8: for (int i = 0; i < history.size(); ++i) {
            Instruction inst = history.get(i);
            switch (inst.command) {
                case "loadDataset": {
                    if (inst.inputs.get("provider").equals("openml.org")) {
                        instances = ReproducibleInstances.fromOpenML(inst.inputs.get("id"), apiKey);
                        continue block8;
                    }
                    if (!inst.inputs.get("provider").startsWith("local")) continue block8;
                    instances = ReproducibleInstances.fromARFF(inst.inputs.get("id"));
                    continue block8;
                }
                case "buildSubsetViaFolds": {
                    String[] ratiosAsStrings = inst.getInputs().get("ratios").split(",");
                    double[] ratios = new double[ratiosAsStrings.length];
                    for (int j = 0; j < ratiosAsStrings.length; ++j) {
                        ratios[j] = Double.parseDouble(ratiosAsStrings[j].trim().substring(1, ratiosAsStrings[j].length() - 1));
                    }
                    instances = WekaUtil.getStratifiedSplit(instances, Long.parseLong(inst.inputs.get("seed")), ratios).get(Integer.parseInt(inst.getInputs().get("outIndex")));
                    continue block8;
                }
            }
        }
        return instances;
    }

    public ReproducibleInstances(ReproducibleInstances dataset) {
        super((Instances)dataset);
        for (Instruction i : dataset.history) {
            this.history.add(i);
        }
        this.cacheLookup = dataset.cacheLookup;
        this.cacheStorage = dataset.cacheStorage;
    }

    public static ReproducibleInstances fromOpenML(String id, String apiKey) throws IOException {
        OpenMLHelper.setApiKey(apiKey);
        ReproducibleInstances result = new ReproducibleInstances(OpenMLHelper.getInstancesById(Integer.parseInt(id)));
        result.history.add(new LoadDataSetInstruction(DataProvider.OPENML, id));
        result.cacheLookup = true;
        result.cacheStorage = true;
        return result;
    }

    public static ReproducibleInstances fromARFF(String path) throws IOException {
        Instances data = new Instances((Reader)new FileReader(path));
        data.setClassIndex(data.numAttributes() - 1);
        ReproducibleInstances result = new ReproducibleInstances(data);
        InetAddress addr = InetAddress.getLocalHost();
        result.history.add(new LoadDataSetInstruction(DataProvider.ARFFFILE, "file://" + addr.getHostName() + File.separator + new File(path).getAbsolutePath()));
        result.cacheLookup = true;
        result.cacheStorage = true;
        return result;
    }

    public List<Instruction> getInstructions() {
        if (this.cacheLookup || this.cacheStorage) {
            return this.history;
        }
        return null;
    }

    public void addInstruction(Instruction i) {
        this.history.add(i);
    }

    public boolean isCacheStorage() {
        return this.cacheStorage;
    }

    public void setCacheStorage(boolean cacheStorage) {
        this.cacheStorage = cacheStorage;
    }

    public boolean isCacheLookup() {
        return this.cacheLookup;
    }

    public void setCacheLookup(boolean cacheLookup) {
        this.cacheLookup = cacheLookup;
    }
}

