/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.classification.multiclass.reduction;

import ai.libs.jaicore.basic.MathExt;
import ai.libs.jaicore.ml.WekaUtil;
import ai.libs.jaicore.ml.classification.multiclass.reduction.reducer.ReductionOptimizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;
import weka.classifiers.Classifier;
import weka.classifiers.rules.OneR;
import weka.core.Instance;
import weka.core.Instances;

public class PipelineOptimizer {
    public static void main(String[] args) throws Exception {
        File folder = new File("../CrcTaskBasedConfigurator/testrsc/polychotomous/");
        Instances inst = new Instances((Reader)new BufferedReader(new FileReader(folder + File.separator + "vowel.arff")));
        inst.setClassIndex(inst.numAttributes() - 1);
        OneR mcc = new OneR();
        String classifierName = "weka.classifiers.trees.RandomForest";
        for (int i = 0; i < inst.classAttribute().numValues(); ++i) {
            System.out.println(i + ": " + inst.classAttribute().value(i));
        }
        for (int j = 0; j < 1; ++j) {
            List<Instances> split = WekaUtil.getStratifiedSplit(inst, (long)j, (double)0.6f);
            System.out.print("Running base learner ...");
            mcc.buildClassifier(split.get(0));
            System.out.println("done. Accuracy: " + PipelineOptimizer.getAccuracy((Classifier)mcc, split.get(1)) + "%");
            ReductionOptimizer c = new ReductionOptimizer(j);
            c.buildClassifier(split.get(0));
            System.out.println("MOD: " + PipelineOptimizer.getAccuracy(c, split.get(1)) + "%");
        }
    }

    private static double getAccuracy(Classifier c, Instances test) throws Exception {
        int mistakes = 0;
        for (Instance i : test) {
            if (c.classifyInstance(i) == i.classValue()) continue;
            ++mistakes;
        }
        return MathExt.round((double)(100.0f * (1.0f - (float)mistakes * 1.0f / (float)test.size())), (int)2);
    }
}

