/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.classification.multiclass.reduction.reducer;

import ai.libs.jaicore.ml.WekaUtil;
import ai.libs.jaicore.ml.classification.multiclass.reduction.EMCNodeType;
import ai.libs.jaicore.ml.classification.multiclass.reduction.reducer.Decision;
import ai.libs.jaicore.ml.classification.multiclass.reduction.reducer.RestProblem;
import ai.libs.jaicore.ml.classification.multiclass.reduction.splitters.ISplitter;
import ai.libs.jaicore.ml.classification.multiclass.reduction.splitters.RPNDSplitter;
import jaicore.search.core.interfaces.GraphGenerator;
import jaicore.search.model.travesaltree.NodeExpansionDescription;
import jaicore.search.model.travesaltree.NodeType;
import jaicore.search.structure.graphgenerator.NodeGoalTester;
import jaicore.search.structure.graphgenerator.SingleRootGenerator;
import jaicore.search.structure.graphgenerator.SuccessorGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.Instances;

public class ReductionGraphGenerator
implements GraphGenerator<RestProblem, Decision> {
    private final Random rand;
    private final Instances data;

    public ReductionGraphGenerator(Random rand, Instances data) {
        this.rand = rand;
        this.data = data;
    }

    public SingleRootGenerator<RestProblem> getRootGenerator() {
        return () -> {
            RestProblem root = new RestProblem(null);
            root.add(new HashSet<String>(WekaUtil.getClassesActuallyContainedInDataset(this.data)));
            return root;
        };
    }

    public SuccessorGenerator<RestProblem, Decision> getSuccessorGenerator() {
        return n -> {
            ArrayList<NodeExpansionDescription> restProblems = new ArrayList<NodeExpansionDescription>();
            try {
                String[] portfolio;
                ArrayList set = new ArrayList((Collection)n.get(0));
                if (set.size() < 2) {
                    throw new UnsupportedOperationException("Cannot create successor where rest problem consists of only one class.");
                }
                ArrayList remainingProblems = new ArrayList();
                for (int j = 1; j < n.size(); ++j) {
                    remainingProblems.add(n.get(j));
                }
                for (String classifier : portfolio = new String[]{"weka.classifiers.trees.RandomForest", "weka.classifiers.functions.SMO", "weka.classifiers.lazy.IBk"}) {
                    for (EMCNodeType eMCNodeType : EMCNodeType.values()) {
                        if (eMCNodeType == EMCNodeType.MERGE) continue;
                        if (this.data.classAttribute().numValues() > 12 && this.data.size() > 1000 && eMCNodeType == EMCNodeType.ALLPAIRS) {
                            System.out.println("Skipping " + (Object)((Object)eMCNodeType) + " with " + classifier + " due to complexity constraints.");
                            continue;
                        }
                        RestProblem rp = new RestProblem(new Decision(null, null, eMCNodeType, AbstractClassifier.forName((String)classifier, null)));
                        rp.addAll(remainingProblems);
                        restProblems.add(new NodeExpansionDescription(n, (Object)rp, (Object)rp.getEdgeToParent(), NodeType.OR));
                    }
                    ArrayList<RPNDSplitter> splitters = new ArrayList<RPNDSplitter>();
                    HashMap<RPNDSplitter, Classifier> classifiers = new HashMap<RPNDSplitter, Classifier>();
                    for (int i = 0; i < 1; ++i) {
                        Classifier classifier2 = AbstractClassifier.forName((String)classifier, null);
                        RPNDSplitter splitter = new RPNDSplitter(this.rand, classifier2);
                        classifiers.put(splitter, classifier2);
                        splitters.add(splitter);
                    }
                    for (ISplitter iSplitter : splitters) {
                        Collection<Collection<String>> split = iSplitter.split(this.data);
                        Iterator<Collection<String>> iterator = split.iterator();
                        HashSet<String> c1 = new HashSet<String>(iterator.next());
                        HashSet<String> c2 = new HashSet<String>(iterator.next());
                        RestProblem rp = new RestProblem(new Decision(c1, c2, EMCNodeType.DIRECT, (Classifier)classifiers.get(iSplitter)));
                        if (c1.size() > 1) {
                            rp.add(c1);
                        }
                        if (c2.size() > 1) {
                            rp.add(c2);
                        }
                        rp.addAll(remainingProblems);
                        restProblems.add(new NodeExpansionDescription(n, (Object)rp, (Object)rp.getEdgeToParent(), NodeType.OR));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return restProblems;
        };
    }

    public NodeGoalTester<RestProblem> getGoalTester() {
        return n -> {
            for (Set open : n) {
                if (open.size() <= 1) continue;
                return false;
            }
            return true;
        };
    }

    public boolean isSelfContained() {
        return false;
    }

    public void setNodeNumbering(boolean nodenumbering) {
    }
}

