/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core;

import ai.libs.jaicore.basic.FileUtil;
import ai.libs.jaicore.ml.core.SimpleInstanceImpl;
import ai.libs.jaicore.ml.interfaces.Instance;
import ai.libs.jaicore.ml.interfaces.Instances;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class SimpleInstancesImpl
extends ArrayList<Instance>
implements Instances {
    private int numColumns = -1;

    public SimpleInstancesImpl() {
    }

    public SimpleInstancesImpl(int initialCapacity) {
        super(initialCapacity);
    }

    public SimpleInstancesImpl(String json) throws IOException {
        this.addAllFromJson(json);
    }

    public SimpleInstancesImpl(JsonNode jsonNode) {
        this.addAllFromJson(jsonNode);
    }

    public SimpleInstancesImpl(File jsonFile) throws IOException {
        this.addAllFromJson(jsonFile);
    }

    @Override
    public boolean add(double[] values) {
        return super.add(new SimpleInstanceImpl(values));
    }

    @Override
    public boolean add(Instance instance) {
        if (this.numColumns < 0) {
            this.numColumns = instance.getNumberOfColumns();
        } else if (this.numColumns != instance.getNumberOfColumns()) {
            throw new IllegalArgumentException("Cannot add " + instance.getNumberOfColumns() + "-valued instance to dataset with " + this.numColumns + " instances.");
        }
        return super.add(instance);
    }

    @Override
    public int getNumberOfRows() {
        return this.size();
    }

    @Override
    public int getNumberOfColumns() {
        return this.numColumns;
    }

    @Override
    public String toJson() {
        ObjectMapper om = new ObjectMapper();
        try {
            return om.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void addAllFromJson(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode root = mapper.readTree(json);
        this.addAllFromJson(root);
    }

    public void addAllFromJson(JsonNode jsonNode) {
        if (!jsonNode.isArray()) {
            throw new IllegalArgumentException("Root node from parsed JSON tree is not an array!");
        }
        for (JsonNode instanceAsJson : jsonNode) {
            SimpleInstanceImpl instance = new SimpleInstanceImpl(instanceAsJson);
            this.add(instance);
        }
    }

    @Override
    public void addAllFromJson(File jsonFile) throws IOException {
        this.addAllFromJson(FileUtil.readFileAsString((File)jsonFile));
    }
}

