/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core;

import ai.libs.jaicore.basic.FileUtil;
import ai.libs.jaicore.ml.core.SimpleLabeledInstanceImpl;
import ai.libs.jaicore.ml.interfaces.LabeledInstance;
import ai.libs.jaicore.ml.interfaces.LabeledInstances;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class SimpleLabeledInstancesImpl
extends ArrayList<LabeledInstance<String>>
implements LabeledInstances<String> {
    private int numColumns = -1;
    private final Set<String> occurringLabels = new HashSet<String>();

    public SimpleLabeledInstancesImpl() {
    }

    public SimpleLabeledInstancesImpl(String json) throws IOException {
        this.addAllFromJson(json);
    }

    public SimpleLabeledInstancesImpl(JsonNode jsonNode) {
        this.addAllFromJson(jsonNode);
    }

    public SimpleLabeledInstancesImpl(File jsonFile) throws IOException {
        this.addAllFromJson(jsonFile);
    }

    @Override
    public boolean add(LabeledInstance<String> instance) {
        if (this.numColumns < 0) {
            this.numColumns = instance.getNumberOfColumns();
        } else if (this.numColumns != instance.getNumberOfColumns()) {
            throw new IllegalArgumentException("Cannot add " + instance.getNumberOfColumns() + "-valued instance to dataset with " + this.numColumns + " instances.");
        }
        this.occurringLabels.add(instance.getLabel());
        return super.add(instance);
    }

    @Override
    public int getNumberOfRows() {
        return this.size();
    }

    @Override
    public int getNumberOfColumns() {
        return this.numColumns;
    }

    @Override
    public String toJson() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode root = om.createObjectNode();
        ArrayNode instances = root.putArray("instances");
        ArrayNode labels = root.putArray("labels");
        for (LabeledInstance instance : this) {
            ArrayNode instanceArray = instances.addArray();
            for (Double val : instance) {
                instanceArray.add(val);
            }
            labels.add((String)instance.getLabel());
        }
        try {
            return om.writeValueAsString((Object)root);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ArrayList<String> getOccurringLabels() {
        return new ArrayList<String>(this.occurringLabels);
    }

    @Override
    public void addAllFromJson(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode root = mapper.readTree(json);
        this.addAllFromJson(root);
    }

    public void addAllFromJson(JsonNode jsonNode) {
        JsonNode instances = jsonNode.get("instances");
        JsonNode labels = jsonNode.get("labels");
        if (labels == null) {
            throw new IllegalArgumentException("No labels provided in the dataset!");
        }
        if (instances.size() != labels.size()) {
            throw new IllegalArgumentException("Number of labels does not match the number of instances!");
        }
        int index = 0;
        for (JsonNode instance : instances) {
            SimpleLabeledInstanceImpl labeledInstance = new SimpleLabeledInstanceImpl();
            for (JsonNode val : instance) {
                labeledInstance.add(val.asDouble());
            }
            labeledInstance.setLabel(labels.get(index++).asText());
            this.add(labeledInstance);
        }
    }

    @Override
    public void addAllFromJson(File jsonFile) throws IOException {
        this.addAllFromJson(FileUtil.readFileAsString((File)jsonFile));
    }
}

