/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.attribute;

import ai.libs.jaicore.ml.core.dataset.attribute.IAttributeType;
import ai.libs.jaicore.ml.core.dataset.attribute.IAttributeValue;

public abstract class AAttributeValue<D>
implements IAttributeValue<D> {
    private D value;
    private final IAttributeType<D> type;

    protected AAttributeValue(IAttributeType<D> type) {
        this.type = type;
    }

    protected AAttributeValue(IAttributeType<D> type, D value) {
        this(type);
        this.setValue(value);
    }

    public IAttributeType<D> getType() {
        return this.type;
    }

    @Override
    public D getValue() {
        return this.value;
    }

    @Override
    public void setValue(D value) {
        if (!this.type.isValidValue(value)) {
            throw new IllegalArgumentException("The attribute value does not conform the domain of the attribute type.");
        }
        this.value = value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AAttributeValue other = (AAttributeValue)obj;
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

