/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.attribute.transformer.multivalue;

import ai.libs.jaicore.ml.core.dataset.attribute.IAttributeValue;
import ai.libs.jaicore.ml.core.dataset.attribute.multivalue.MultiValueAttributeType;
import ai.libs.jaicore.ml.core.dataset.attribute.multivalue.MultiValueAttributeValue;
import ai.libs.jaicore.ml.core.dataset.attribute.transformer.ISingleAttributeTransformer;
import java.util.Collection;
import java.util.LinkedList;

public class MultiValueBinaryzationTransformer
implements ISingleAttributeTransformer {
    @Override
    public double[] transformAttribute(IAttributeValue<?> attributeToTransform) {
        if (!(attributeToTransform instanceof MultiValueAttributeValue)) {
            throw new IllegalArgumentException("Can only perform Multi-Value Binaryzation for multi-value attributes.");
        }
        MultiValueAttributeValue value = (MultiValueAttributeValue)attributeToTransform;
        MultiValueAttributeType type = (MultiValueAttributeType)value.getType();
        LinkedList<String> domain = new LinkedList<String>();
        domain.addAll(type.getDomain());
        domain.sort(String::compareTo);
        double[] binaryzation = new double[domain.size()];
        for (int i = 0; i < binaryzation.length; ++i) {
            binaryzation[i] = ((Collection)value.getValue()).contains(domain.get(i)) ? 1.0 : 0.0;
        }
        return binaryzation;
    }
}

