/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.sampling.infiles;

import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.ml.core.dataset.ArffUtilities;
import ai.libs.jaicore.ml.core.dataset.sampling.SampleElementAddedEvent;
import ai.libs.jaicore.ml.core.dataset.sampling.infiles.AFileSamplingAlgorithm;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Random;

public class ReservoirSampling
extends AFileSamplingAlgorithm {
    private Random random;
    private BufferedReader reader;
    private int datapointAmount;
    private int streamedDatapoints;
    private String[] sampledDatapoints;

    public ReservoirSampling(Random random, File input) {
        super(input);
        this.random = random;
    }

    public AlgorithmEvent nextWithException() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmException {
        switch (this.getState()) {
            case created: {
                try {
                    this.datapointAmount = ArffUtilities.countDatasetEntries((File)this.getInput(), true);
                    this.streamedDatapoints = 0;
                    this.sampledDatapoints = new String[this.sampleSize.intValue()];
                    this.reader = new BufferedReader(new FileReader((File)this.getInput()));
                    ArffUtilities.skipWithReaderToDatapoints(this.reader);
                    return this.activate();
                }
                catch (IOException e) {
                    throw new AlgorithmException((Throwable)e, "Was not able to count the datapoints.");
                }
            }
            case active: {
                if (this.streamedDatapoints < this.datapointAmount) {
                    try {
                        String datapoint = this.reader.readLine();
                        if (datapoint != null && datapoint.trim().length() > 0 && datapoint.trim().charAt(0) != '%') {
                            if (this.streamedDatapoints < this.sampleSize) {
                                this.sampledDatapoints[this.streamedDatapoints] = datapoint.trim();
                            } else {
                                int j = this.random.nextInt(this.streamedDatapoints);
                                if (j < this.sampleSize) {
                                    this.sampledDatapoints[j] = datapoint.trim();
                                }
                            }
                        }
                        ++this.streamedDatapoints;
                        return new SampleElementAddedEvent(this.getId());
                    }
                    catch (IOException e) {
                        throw new AlgorithmException((Throwable)e, "Was not able to read datapoint line from input file");
                    }
                }
                try {
                    this.reader.close();
                    for (int i = 0; i < this.sampledDatapoints.length; ++i) {
                        this.outputFileWriter.write(this.sampledDatapoints[i] + "\n");
                    }
                    return this.terminate();
                }
                catch (IOException e) {
                    throw new AlgorithmException((Throwable)e, "Was not able to write sampled datapoints into output files.");
                }
            }
            case inactive: {
                if (this.streamedDatapoints < this.datapointAmount) {
                    throw new AlgorithmException("Expected sample size was not reached before termination");
                }
                return this.terminate();
            }
        }
        throw new IllegalStateException("Unknown algorithm state " + this.getState());
    }

    @Override
    protected void cleanUp() {
    }
}

