/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.sampling.inmemory;

import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.ml.core.dataset.IDataset;
import ai.libs.jaicore.ml.core.dataset.IInstance;
import ai.libs.jaicore.ml.core.dataset.sampling.SampleElementAddedEvent;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.ASamplingAlgorithm;
import java.util.List;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.distance.ManhattanDistance;

public abstract class ClusterSampling<I extends IInstance>
extends ASamplingAlgorithm<I> {
    protected List<CentroidCluster<I>> clusterResults = null;
    protected int currentCluster = 0;
    protected DistanceMeasure distanceMeassure = new ManhattanDistance();
    protected long seed;

    protected ClusterSampling(long seed, IDataset<I> input) {
        super(input);
        this.seed = seed;
    }

    protected ClusterSampling(long seed, DistanceMeasure dist, IDataset<I> input) {
        super(input);
        this.seed = seed;
        this.distanceMeassure = dist;
    }

    public List<CentroidCluster<I>> getClusterResults() {
        return this.clusterResults;
    }

    public void setClusterResults(List<CentroidCluster<I>> clusterResults) {
        this.clusterResults = clusterResults;
    }

    public void setDistanceMeassure(DistanceMeasure distanceMeassure) {
        this.distanceMeassure = distanceMeassure;
    }

    public AlgorithmEvent doAlgorithmStep() {
        if (this.currentCluster < this.clusterResults.size()) {
            int i;
            CentroidCluster<I> cluster = this.clusterResults.get(this.currentCluster++);
            boolean same = true;
            for (i = 1; i < cluster.getPoints().size(); ++i) {
                if (((IInstance)cluster.getPoints().get(i - 1)).getTargetValue(Double.class).equals(((IInstance)cluster.getPoints().get(i)).getTargetValue(Double.class))) continue;
                same = false;
                break;
            }
            if (same) {
                IInstance near = (IInstance)cluster.getPoints().get(0);
                double dist = Double.MAX_VALUE;
                for (IInstance p : cluster.getPoints()) {
                    double newDist = this.distanceMeassure.compute(p.getPoint(), cluster.getCenter().getPoint());
                    if (!(newDist < dist)) continue;
                    near = p;
                    dist = newDist;
                }
                this.sample.add(near);
            } else {
                for (i = 0; i < cluster.getPoints().size(); ++i) {
                    this.sample.add(cluster.getPoints().get(i));
                }
            }
            return new SampleElementAddedEvent(this.getId());
        }
        return this.terminate();
    }
}

