/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.sampling.inmemory;

import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.ml.core.dataset.IDataset;
import ai.libs.jaicore.ml.core.dataset.IInstance;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.ClusterSampling;
import java.util.Collection;
import org.apache.commons.math3.ml.clustering.KMeansPlusPlusClusterer;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.commons.math3.random.RandomGenerator;

public class KmeansSampling<I extends IInstance>
extends ClusterSampling<I> {
    private int k;

    public KmeansSampling(long seed, int k, IDataset<I> input) {
        super(seed, input);
        this.k = k;
    }

    public KmeansSampling(long seed, DistanceMeasure dist, IDataset<I> input) {
        super(seed, dist, input);
        this.k = -1;
    }

    public KmeansSampling(long seed, int k, DistanceMeasure dist, IDataset<I> input) {
        super(seed, dist, input);
        this.k = k;
    }

    public AlgorithmEvent nextWithException() throws AlgorithmException {
        switch (this.getState()) {
            case created: {
                this.sample = ((IDataset)this.getInput()).createEmpty();
                JDKRandomGenerator r = new JDKRandomGenerator();
                r.setSeed(this.seed);
                if (this.k == -1) {
                    this.k = this.sampleSize;
                }
                if (this.clusterResults == null) {
                    KMeansPlusPlusClusterer kMeansCluster = new KMeansPlusPlusClusterer(this.k, -1, this.distanceMeassure, (RandomGenerator)r);
                    this.clusterResults = kMeansCluster.cluster((Collection)this.getInput());
                }
                return this.activate();
            }
            case active: {
                this.doAlgorithmStep();
                break;
            }
            case inactive: {
                this.doInactiveStep();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown algorithm state " + this.getState());
            }
        }
        return null;
    }
}

