/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.sampling.inmemory;

import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.ml.core.dataset.IDataset;
import ai.libs.jaicore.ml.core.dataset.IInstance;
import ai.libs.jaicore.ml.core.dataset.sampling.SampleElementAddedEvent;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.ASamplingAlgorithm;
import java.util.Collection;
import java.util.Comparator;
import java.util.Random;

public class SystematicSampling<I extends IInstance>
extends ASamplingAlgorithm<I> {
    private Random random;
    private IDataset<I> sortedDataset = null;
    private int k;
    private int startIndex;
    private int index;
    private Comparator<I> datapointComparator = (o1, o2) -> {
        double[] v1 = o1.getPoint();
        double[] v2 = o2.getPoint();
        for (int i = 0; i < Math.min(v1.length, v2.length); ++i) {
            int c = Double.compare(v1[i], v2[i]);
            if (c == 0) continue;
            return c;
        }
        return 0;
    };

    public SystematicSampling(Random random, IDataset<I> input) {
        super(input);
        this.random = random;
    }

    public SystematicSampling(Random random, Comparator<I> datapointComparator, IDataset<I> input) {
        super(input);
        this.random = random;
        this.datapointComparator = datapointComparator;
    }

    public AlgorithmEvent nextWithException() throws AlgorithmException {
        switch (this.getState()) {
            case created: {
                this.sample = ((IDataset)this.getInput()).createEmpty();
                if (this.sortedDataset == null) {
                    this.sortedDataset = ((IDataset)this.getInput()).createEmpty();
                    this.sortedDataset.addAll((Collection)this.getInput());
                    this.sortedDataset.sort(this.datapointComparator);
                }
                this.startIndex = this.random.nextInt(this.sortedDataset.size());
                this.k = this.sortedDataset.size() / this.sampleSize;
                this.index = 0;
                return this.activate();
            }
            case active: {
                if (this.sample.size() < this.sampleSize) {
                    int e = (this.startIndex + this.index++ * this.k) % this.sortedDataset.size();
                    this.sample.add(this.sortedDataset.get(e));
                    return new SampleElementAddedEvent(this.getId());
                }
                return this.terminate();
            }
            case inactive: {
                this.doInactiveStep();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown algorithm state " + this.getState());
            }
        }
        return null;
    }

    public IDataset<I> getSortedDataset() {
        return this.sortedDataset;
    }

    public void setSortedDataset(IDataset<I> sortedDataset) {
        this.sortedDataset = sortedDataset;
    }
}

