/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.sampling.inmemory.casecontrol;

import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.ml.core.dataset.IDataset;
import ai.libs.jaicore.ml.core.dataset.IInstance;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.ASamplingAlgorithm;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

public abstract class CaseControlLikeSampling<I extends IInstance>
extends ASamplingAlgorithm<I> {
    protected Random rand;
    protected List<SetUtil.Pair<I, Double>> probabilityBoundaries = null;

    protected CaseControlLikeSampling(IDataset<I> input) {
        super(input);
    }

    public List<SetUtil.Pair<I, Double>> getProbabilityBoundaries() {
        return this.probabilityBoundaries;
    }

    public void setProbabilityBoundaries(List<SetUtil.Pair<I, Double>> probabilityBoundaries) {
        this.probabilityBoundaries = probabilityBoundaries;
    }

    protected HashMap<Object, Integer> countClassOccurrences(IDataset<I> dataset) {
        HashMap<Object, Integer> classOccurrences = new HashMap<Object, Integer>();
        for (IInstance instance : dataset) {
            boolean classExists = false;
            for (Object clazz : classOccurrences.keySet()) {
                if (!clazz.equals(instance.getTargetValue(Object.class).getValue())) continue;
                classExists = true;
            }
            if (classExists) {
                classOccurrences.put(instance.getTargetValue(Object.class).getValue(), classOccurrences.get(instance.getTargetValue(Object.class).getValue()) + 1);
                continue;
            }
            classOccurrences.put(instance.getTargetValue(Object.class).getValue(), 0);
        }
        return classOccurrences;
    }

    protected List<SetUtil.Pair<I, Double>> calculateInstanceBoundaries(HashMap<Object, Integer> classOccurrences, int numberOfClasses) {
        double boundaryOfCurrentInstance = 0.0;
        ArrayList<SetUtil.Pair<I, Double>> boundaries = new ArrayList<SetUtil.Pair<I, Double>>();
        for (IInstance instance : (IDataset)this.getInput()) {
            boundaries.add(new SetUtil.Pair((Object)instance, (Object)(boundaryOfCurrentInstance += 1.0 / (double)classOccurrences.get(instance.getTargetValue(Object.class).getValue()).intValue() / (double)numberOfClasses)));
        }
        return boundaries;
    }
}

