/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.sampling.inmemory.casecontrol;

import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.ml.core.dataset.IDataset;
import ai.libs.jaicore.ml.core.dataset.IInstance;
import ai.libs.jaicore.ml.core.dataset.sampling.SampleElementAddedEvent;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.casecontrol.CaseControlLikeSampling;
import java.util.HashMap;
import java.util.Random;

public class CaseControlSampling<I extends IInstance>
extends CaseControlLikeSampling<I> {
    public CaseControlSampling(Random rand, IDataset<I> input) {
        super(input);
        this.rand = rand;
    }

    public AlgorithmEvent nextWithException() throws AlgorithmException {
        switch (this.getState()) {
            case created: {
                this.sample = ((IDataset)this.getInput()).createEmpty();
                HashMap<Object, Integer> classOccurrences = this.countClassOccurrences((IDataset)this.getInput());
                int numberOfClasses = classOccurrences.keySet().size();
                if (this.probabilityBoundaries == null) {
                    this.probabilityBoundaries = this.calculateInstanceBoundaries(classOccurrences, numberOfClasses);
                }
                return this.activate();
            }
            case active: {
                if (this.sample.size() < this.sampleSize) {
                    IInstance choosenInstance = null;
                    do {
                        double r = this.rand.nextDouble();
                        for (int i = 0; i < this.probabilityBoundaries.size(); ++i) {
                            if (!((Double)((SetUtil.Pair)this.probabilityBoundaries.get(i)).getY() > r)) continue;
                            choosenInstance = (IInstance)((SetUtil.Pair)this.probabilityBoundaries.get(i)).getX();
                            break;
                        }
                        if (choosenInstance != null) continue;
                        choosenInstance = (IInstance)((SetUtil.Pair)this.probabilityBoundaries.get(this.probabilityBoundaries.size() - 1)).getX();
                    } while (this.sample.contains(choosenInstance));
                    this.sample.add(choosenInstance);
                    return new SampleElementAddedEvent(this.getId());
                }
                return this.terminate();
            }
            case inactive: {
                this.doInactiveStep();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown algorithm state " + this.getState());
            }
        }
        return null;
    }
}

