/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.sampling.inmemory.casecontrol;

import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.ml.core.dataset.IDataset;
import ai.libs.jaicore.ml.core.dataset.IInstance;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.casecontrol.PilotEstimateSampling;
import ai.libs.jaicore.ml.core.dataset.standard.SimpleDataset;
import ai.libs.jaicore.ml.core.dataset.weka.WekaInstancesUtil;
import java.util.ArrayList;
import java.util.Random;
import weka.classifiers.Classifier;
import weka.core.Instance;
import weka.core.Instances;

public class LocalCaseControlSampling<I extends IInstance>
extends PilotEstimateSampling<I> {
    public LocalCaseControlSampling(Random rand, int preSampleSize, IDataset<I> input) {
        super(input);
        this.rand = rand;
        this.preSampleSize = preSampleSize;
    }

    @Override
    protected ArrayList<SetUtil.Pair<I, Double>> calculateFinalInstanceBoundaries(Instances instances, Classifier pilotEstimator) {
        double loss;
        double boundaryOfCurrentInstance = 0.0;
        ArrayList<SetUtil.Pair> instanceProbabilityBoundaries = new ArrayList<SetUtil.Pair>();
        double sumOfDistributionLosses = 0.0;
        for (Instance instance : instances) {
            try {
                loss = 1.0 - pilotEstimator.distributionForInstance(instance)[(int)instance.classValue()];
            }
            catch (Exception e) {
                loss = 1.0;
            }
            sumOfDistributionLosses += loss;
        }
        for (Instance instance : instances) {
            try {
                loss = 1.0 - pilotEstimator.distributionForInstance(instance)[(int)instance.classValue()];
            }
            catch (Exception e) {
                loss = 1.0;
            }
            instanceProbabilityBoundaries.add(new SetUtil.Pair((Object)instance, (Object)(boundaryOfCurrentInstance += loss / sumOfDistributionLosses)));
        }
        SimpleDataset dataset = WekaInstancesUtil.wekaInstancesToDataset(instances);
        ArrayList<SetUtil.Pair<I, Double>> probabilityBoundaries = new ArrayList<SetUtil.Pair<I, Double>>();
        int iterator = 0;
        for (IInstance instance : dataset) {
            probabilityBoundaries.add(new SetUtil.Pair((Object)instance, ((SetUtil.Pair)instanceProbabilityBoundaries.get(iterator)).getY()));
            ++iterator;
        }
        return probabilityBoundaries;
    }
}

