/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.sampling.inmemory.casecontrol;

import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.ml.core.dataset.IDataset;
import ai.libs.jaicore.ml.core.dataset.IInstance;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.casecontrol.PilotEstimateSampling;
import ai.libs.jaicore.ml.core.dataset.standard.SimpleDataset;
import ai.libs.jaicore.ml.core.dataset.weka.WekaInstancesUtil;
import java.util.ArrayList;
import java.util.Random;
import weka.classifiers.Classifier;
import weka.core.Instance;
import weka.core.Instances;

public class OSMAC<I extends IInstance>
extends PilotEstimateSampling<I> {
    public OSMAC(Random rand, int preSampleSize, IDataset<I> input) {
        super(input);
        this.rand = rand;
        this.preSampleSize = preSampleSize;
    }

    @Override
    protected ArrayList<SetUtil.Pair<I, Double>> calculateFinalInstanceBoundaries(Instances instances, Classifier pilotEstimator) {
        double loss;
        int vectorLength;
        double boundaryOfCurrentInstance = 0.0;
        ArrayList<SetUtil.Pair<I, Double>> probabilityBoundaries = new ArrayList<SetUtil.Pair<I, Double>>();
        ArrayList<SetUtil.Pair> instanceProbabilityBoundaries = new ArrayList<SetUtil.Pair>();
        double sumOfDistributionLosses = 0.0;
        for (Instance instance : instances) {
            vectorLength = 0;
            for (Object object : instance.toDoubleArray()) {
                vectorLength = (int)((double)vectorLength + object);
            }
            try {
                loss = 1.0 - pilotEstimator.distributionForInstance(instance)[(int)instance.classValue()];
            }
            catch (Exception e) {
                loss = 1.0;
            }
            sumOfDistributionLosses += loss * (double)vectorLength;
        }
        for (Instance instance : instances) {
            vectorLength = 0;
            double[] e = instance.toDoubleArray();
            int n = e.length;
            for (int i = 0; i < n; ++i) {
                Object object;
                object = e[i];
                vectorLength = (int)((double)vectorLength + object);
            }
            try {
                loss = 1.0 - pilotEstimator.distributionForInstance(instance)[(int)instance.classValue()];
            }
            catch (Exception e2) {
                loss = 1.0;
            }
            instanceProbabilityBoundaries.add(new SetUtil.Pair((Object)instance, (Object)(boundaryOfCurrentInstance += loss * (double)vectorLength / sumOfDistributionLosses)));
        }
        SimpleDataset dataset = WekaInstancesUtil.wekaInstancesToDataset(instances);
        int iterator = 0;
        Object object = dataset.iterator();
        while (object.hasNext()) {
            IInstance instance = (IInstance)object.next();
            probabilityBoundaries.add(new SetUtil.Pair((Object)instance, ((SetUtil.Pair)instanceProbabilityBoundaries.get(iterator)).getY()));
            ++iterator;
        }
        return probabilityBoundaries;
    }
}

