/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.sampling.inmemory.casecontrol;

import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.ml.core.dataset.IDataset;
import ai.libs.jaicore.ml.core.dataset.IInstance;
import ai.libs.jaicore.ml.core.dataset.sampling.SampleElementAddedEvent;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.casecontrol.CaseControlLikeSampling;
import ai.libs.jaicore.ml.core.dataset.weka.WekaInstances;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.classifiers.Classifier;
import weka.classifiers.functions.Logistic;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NumericToNominal;

public abstract class PilotEstimateSampling<I extends IInstance>
extends CaseControlLikeSampling<I> {
    private Logger logger = LoggerFactory.getLogger(PilotEstimateSampling.class);
    protected int preSampleSize;
    private I chosenInstance = null;

    protected PilotEstimateSampling(IDataset<I> input) {
        super(input);
    }

    public I getChosenInstance() {
        return this.chosenInstance;
    }

    public void setChosenInstance(I chosenInstance) {
        this.chosenInstance = chosenInstance;
    }

    public AlgorithmEvent nextWithException() throws AlgorithmException {
        switch (this.getState()) {
            case created: {
                this.doInitStep();
                break;
            }
            case active: {
                if (this.sample.size() < this.sampleSize) {
                    do {
                        double r = this.rand.nextDouble();
                        this.chosenInstance = null;
                        for (int i = 0; i < this.probabilityBoundaries.size(); ++i) {
                            if (!((Double)((SetUtil.Pair)this.probabilityBoundaries.get(i)).getY() > r)) continue;
                            this.chosenInstance = (IInstance)((SetUtil.Pair)this.probabilityBoundaries.get(i)).getX();
                            break;
                        }
                        if (this.chosenInstance != null) continue;
                        this.chosenInstance = (IInstance)((SetUtil.Pair)this.probabilityBoundaries.get(this.probabilityBoundaries.size() - 1)).getX();
                    } while (this.sample.contains(this.chosenInstance));
                    this.sample.add(this.chosenInstance);
                    return new SampleElementAddedEvent(this.getId());
                }
                return this.terminate();
            }
            case inactive: {
                this.doInactiveStep();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown algorithm state " + this.getState());
            }
        }
        return null;
    }

    private AlgorithmEvent doInitStep() {
        this.sample = ((IDataset)this.getInput()).createEmpty();
        if (this.probabilityBoundaries == null || this.chosenInstance == null) {
            Logistic pilotEstimator = new Logistic();
            if (this.preSampleSize < 1) {
                this.preSampleSize = ((IDataset)this.getInput()).size() / 2;
            }
            IDataset pilotEstimateSample = ((IDataset)this.getInput()).createEmpty();
            IDataset sampleCopy = ((IDataset)this.getInput()).createEmpty();
            for (IInstance instance : (IDataset)this.getInput()) {
                sampleCopy.add(instance);
            }
            HashMap<Object, Integer> classOccurrences = this.countClassOccurrences(sampleCopy);
            int numberOfClasses = classOccurrences.keySet().size();
            this.probabilityBoundaries = this.calculateInstanceBoundaries(classOccurrences, numberOfClasses);
            for (int i = 0; i < this.preSampleSize; ++i) {
                IInstance choosenInstance;
                do {
                    double r = this.rand.nextDouble();
                    choosenInstance = null;
                    for (int j = 0; j < this.probabilityBoundaries.size(); ++j) {
                        if (!((Double)((SetUtil.Pair)this.probabilityBoundaries.get(j)).getY() > r)) continue;
                        choosenInstance = (IInstance)((SetUtil.Pair)this.probabilityBoundaries.get(j)).getX();
                        break;
                    }
                    if (choosenInstance != null) continue;
                    choosenInstance = (IInstance)((SetUtil.Pair)this.probabilityBoundaries.get(this.probabilityBoundaries.size() - 1)).getX();
                } while (pilotEstimateSample.contains(choosenInstance));
                pilotEstimateSample.add(choosenInstance);
            }
            Instances pilotEstimateInstances = (Instances)((WekaInstances)pilotEstimateSample).getList();
            NumericToNominal numericToNominal = new NumericToNominal();
            String[] options = new String[]{"-R", "last"};
            try {
                numericToNominal.setOptions(options);
                numericToNominal.setInputFormat(pilotEstimateInstances);
            }
            catch (Exception e) {
                this.logger.error("Unexpected error", (Throwable)e);
                this.terminate();
            }
            try {
                pilotEstimateInstances = Filter.useFilter((Instances)pilotEstimateInstances, (Filter)numericToNominal);
            }
            catch (Exception e) {
                this.logger.error("Cannot apply filter", (Throwable)e);
                this.terminate();
            }
            ArrayList<SetUtil.Pair> classMapping = new ArrayList<SetUtil.Pair>();
            for (Instance in : pilotEstimateInstances) {
                boolean classNotInMapping = true;
                for (SetUtil.Pair classPair : classMapping) {
                    if (in.classValue() != ((Double)classPair.getX()).doubleValue()) continue;
                    classNotInMapping = false;
                }
                if (!classNotInMapping) continue;
                classMapping.add(new SetUtil.Pair((Object)in.classValue(), (Object)classMapping.size()));
            }
            try {
                pilotEstimator.buildClassifier(pilotEstimateInstances);
            }
            catch (Exception e) {
                this.logger.error("Cannot build classifier", (Throwable)e);
                this.terminate();
            }
            this.probabilityBoundaries = this.calculateFinalInstanceBoundaries((Instances)((WekaInstances)sampleCopy).getList(), (Classifier)pilotEstimator);
        }
        return this.activate();
    }

    abstract ArrayList<SetUtil.Pair<I, Double>> calculateFinalInstanceBoundaries(Instances var1, Classifier var2);
}

