/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.sampling.inmemory.factories;

import ai.libs.jaicore.ml.core.dataset.IDataset;
import ai.libs.jaicore.ml.core.dataset.IInstance;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.KmeansSampling;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.factories.interfaces.IRerunnableSamplingAlgorithmFactory;
import java.util.Random;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.distance.ManhattanDistance;

public class KmeansSamplingFactory<I extends IInstance>
implements IRerunnableSamplingAlgorithmFactory<I, KmeansSampling<I>> {
    private KmeansSampling<I> previousRun;
    private int k = -1;
    private long clusterSeed = System.currentTimeMillis();
    private DistanceMeasure distanceMeassure = new ManhattanDistance();

    @Override
    public void setPreviousRun(KmeansSampling<I> previousRun) {
        this.previousRun = previousRun;
    }

    public void setK(int k) {
        this.k = k;
    }

    public void setClusterSeed(long clusterSeed) {
        this.clusterSeed = clusterSeed;
    }

    public void setDistanceMeassure(DistanceMeasure distanceMeassure) {
        this.distanceMeassure = distanceMeassure;
    }

    @Override
    public KmeansSampling<I> getAlgorithm(int sampleSize, IDataset<I> inputDataset, Random random) {
        int kValue = sampleSize;
        if (this.k > 0) {
            kValue = this.k;
        }
        KmeansSampling kmeansSampling = new KmeansSampling(this.clusterSeed, kValue, inputDataset);
        kmeansSampling.setSampleSize(sampleSize);
        kmeansSampling.setDistanceMeassure(this.distanceMeassure);
        if (this.previousRun != null && this.previousRun.getClusterResults() != null) {
            kmeansSampling.setClusterResults(this.previousRun.getClusterResults());
        }
        return kmeansSampling;
    }
}

