/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.sampling.inmemory.factories;

import ai.libs.jaicore.ml.core.dataset.IDataset;
import ai.libs.jaicore.ml.core.dataset.IInstance;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.casecontrol.OSMAC;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.factories.interfaces.IRerunnableSamplingAlgorithmFactory;
import java.util.Random;

public class OSMACSamplingFactory<I extends IInstance>
implements IRerunnableSamplingAlgorithmFactory<I, OSMAC<I>> {
    private OSMAC<I> previousRun;
    private int preSampleSize = -1;

    public void setPreSampleSize(int preSampleSize) {
        this.preSampleSize = preSampleSize;
    }

    @Override
    public void setPreviousRun(OSMAC<I> previousRun) {
        this.previousRun = previousRun;
    }

    @Override
    public OSMAC<I> getAlgorithm(int sampleSize, IDataset<I> inputDataset, Random random) {
        OSMAC osmac = new OSMAC(random, this.preSampleSize, inputDataset);
        if (this.previousRun != null && this.previousRun.getProbabilityBoundaries() != null) {
            osmac.setProbabilityBoundaries(this.previousRun.getProbabilityBoundaries());
            osmac.setChosenInstance(this.previousRun.getChosenInstance());
        }
        osmac.setSampleSize(sampleSize);
        return osmac;
    }
}

