/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.sampling.inmemory.factories;

import ai.libs.jaicore.ml.core.dataset.IDataset;
import ai.libs.jaicore.ml.core.dataset.IInstance;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.factories.interfaces.IRerunnableSamplingAlgorithmFactory;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.stratified.sampling.IStratiAmountSelector;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.stratified.sampling.IStratiAssigner;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.stratified.sampling.StratifiedSampling;
import java.util.Random;

public class StratifiedSamplingFactory<I extends IInstance>
implements IRerunnableSamplingAlgorithmFactory<I, StratifiedSampling<I>> {
    private IStratiAmountSelector<I> stratiAmountSelector;
    private IStratiAssigner<I> stratiAssigner;
    private StratifiedSampling<I> previousRun = null;

    public StratifiedSamplingFactory(IStratiAmountSelector<I> stratiAmountSelector, IStratiAssigner<I> stratiAssigner) {
        this.stratiAmountSelector = stratiAmountSelector;
        this.stratiAssigner = stratiAssigner;
    }

    @Override
    public void setPreviousRun(StratifiedSampling<I> previousRun) {
        this.previousRun = previousRun;
    }

    @Override
    public StratifiedSampling<I> getAlgorithm(int sampleSize, IDataset<I> inputDataset, Random random) {
        StratifiedSampling<I> stratifiedSampling = new StratifiedSampling<I>(this.stratiAmountSelector, this.stratiAssigner, random, inputDataset);
        stratifiedSampling.setSampleSize(sampleSize);
        if (this.previousRun != null && this.previousRun.getStrati() != null) {
            stratifiedSampling.setStrati(this.previousRun.getStrati());
        }
        return stratifiedSampling;
    }
}

