/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.sampling.inmemory.factories;

import ai.libs.jaicore.ml.core.dataset.IDataset;
import ai.libs.jaicore.ml.core.dataset.IInstance;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.SystematicSampling;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.factories.interfaces.IRerunnableSamplingAlgorithmFactory;
import java.util.Comparator;
import java.util.Random;

public class SystematicSamplingFactory<I extends IInstance>
implements IRerunnableSamplingAlgorithmFactory<I, SystematicSampling<I>> {
    private Comparator<I> datapointComparator = null;
    private SystematicSampling<I> previousRun = null;

    public void setDatapointComparator(Comparator<I> datapointComparator) {
        this.datapointComparator = datapointComparator;
    }

    @Override
    public void setPreviousRun(SystematicSampling<I> previousRun) {
        this.previousRun = previousRun;
    }

    @Override
    public SystematicSampling<I> getAlgorithm(int sampleSize, IDataset<I> inputDataset, Random random) {
        SystematicSampling<I> systematicSampling = this.datapointComparator != null ? new SystematicSampling<I>(random, this.datapointComparator, inputDataset) : new SystematicSampling<I>(random, inputDataset);
        systematicSampling.setSampleSize(sampleSize);
        if (this.previousRun != null && this.previousRun.getSortedDataset() != null) {
            systematicSampling.setSortedDataset(this.previousRun.getSortedDataset());
        }
        return systematicSampling;
    }
}

