/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.sampling.inmemory.stratified.sampling;

import ai.libs.jaicore.ml.core.dataset.IInstance;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.stratified.sampling.IStratiAssigner;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClusterStratiAssigner<I extends IInstance>
implements IStratiAssigner<I> {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterStratiAssigner.class);
    protected int randomSeed;
    protected DistanceMeasure distanceMeasure;
    protected List<CentroidCluster<I>> clusters;

    @Override
    public int assignToStrati(IInstance datapoint) {
        for (int i = 0; i < this.clusters.size(); ++i) {
            List clusterPoints = this.clusters.get(i).getPoints();
            for (int n = 0; n < clusterPoints.size(); ++n) {
                if (!Arrays.equals(datapoint.getPoint(), ((IInstance)clusterPoints.get(n)).getPoint())) continue;
                return i;
            }
        }
        throw new IllegalStateException("Datapoint was not found in any cluster. This should not happen.");
    }

    @Override
    public void setNumCPUs(int numberOfCPUs) {
        LOG.warn("setNumCPUs() is not supported for this class");
    }

    @Override
    public int getNumCPUs() {
        return 1;
    }
}

