/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.sampling.inmemory.stratified.sampling;

import ai.libs.jaicore.ml.core.dataset.IDataset;
import ai.libs.jaicore.ml.core.dataset.IInstance;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ListProcessor<I extends IInstance>
implements Callable<Map<Integer, Set<Object>>> {
    private static final Logger LOG = LoggerFactory.getLogger(ListProcessor.class);
    private List<I> list;
    private Set<Integer> attributeIndices;
    private IDataset<I> dataset;

    public ListProcessor(List<I> list, Set<Integer> attributeIndices, IDataset<I> dataset) {
        this.list = list;
        this.attributeIndices = attributeIndices;
        this.dataset = dataset;
    }

    @Override
    public Map<Integer, Set<Object>> call() {
        if (LOG.isInfoEnabled()) {
            LOG.info(String.format("Starting computation on local sublist of length %d", this.list.size()));
        }
        HashMap<Integer, Set<Object>> attributeValues = new HashMap<Integer, Set<Object>>();
        for (int attributeIndex : this.attributeIndices) {
            attributeValues.put(attributeIndex, new HashSet());
        }
        for (IInstance instance : this.list) {
            for (int attributeIndex : this.attributeIndices) {
                if (attributeIndex == this.dataset.getNumberOfAttributes()) {
                    ((Set)attributeValues.get(attributeIndex)).add(instance.getTargetValue(Object.class).getValue());
                    continue;
                }
                ((Set)attributeValues.get(attributeIndex)).add(instance.getAttributeValue(attributeIndex, Object.class).getValue());
            }
        }
        LOG.info("Finished local computation");
        return attributeValues;
    }
}

