/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.standard;

import ai.libs.jaicore.ml.core.dataset.ContainsNonNumericAttributesException;
import ai.libs.jaicore.ml.core.dataset.IInstance;
import ai.libs.jaicore.ml.core.dataset.InstanceSchema;
import ai.libs.jaicore.ml.core.dataset.attribute.IAttributeValue;
import ai.libs.jaicore.ml.core.dataset.attribute.categorical.CategoricalAttributeValue;
import ai.libs.jaicore.ml.core.dataset.attribute.primitive.NumericAttributeValue;
import ai.libs.jaicore.ml.core.dataset.attribute.transformer.OneHotEncodingTransformer;
import java.util.ArrayList;
import java.util.LinkedList;

public class SimpleInstance
implements IInstance {
    private static final long serialVersionUID = -6945848041078727475L;
    private InstanceSchema schema;
    private final OneHotEncodingTransformer oneHotEncoder = new OneHotEncodingTransformer();
    private final ArrayList<IAttributeValue<?>> attributeValues;
    private final IAttributeValue<?> targetValue;

    public SimpleInstance(ArrayList<IAttributeValue<?>> attributeValues, IAttributeValue<?> targetValue) {
        this.attributeValues = attributeValues;
        this.targetValue = targetValue;
    }

    public SimpleInstance(InstanceSchema schema, ArrayList<IAttributeValue<?>> attributeValues, IAttributeValue<?> targetValue) {
        this(attributeValues, targetValue);
        this.schema = schema;
    }

    @Override
    public <T> IAttributeValue<T> getAttributeValue(int position, Class<T> type) {
        return this.attributeValues.get(position);
    }

    @Override
    public <T> IAttributeValue<T> getTargetValue(Class<T> type) {
        return this.targetValue;
    }

    public void setSchema(InstanceSchema schema) {
        this.schema = schema;
    }

    @Override
    public double[] getAsDoubleVector() throws ContainsNonNumericAttributesException {
        LinkedList<Double> doubleList = new LinkedList<Double>();
        for (IAttributeValue<?> val : this.attributeValues) {
            if (val instanceof CategoricalAttributeValue) {
                double[] transformedValues;
                for (double doubVal : transformedValues = this.oneHotEncoder.transformAttribute(val)) {
                    doubleList.add(doubVal);
                }
                continue;
            }
            if (val instanceof NumericAttributeValue) {
                doubleList.add((Double)((NumericAttributeValue)val).getValue());
                continue;
            }
            throw new ContainsNonNumericAttributesException("Could not convert all the attribute values to a double vector representation.");
        }
        return doubleList.stream().mapToDouble(x -> x).toArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IAttributeValue<?> val : this.attributeValues) {
            sb.append(val.getValue());
            sb.append(";");
        }
        sb.append(this.targetValue.getValue());
        return sb.toString();
    }
}

