/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.evaluation.measure.multilabel;

import ai.libs.jaicore.ml.core.evaluation.measure.multilabel.ADecomposableMultilabelMeasure;
import ai.libs.jaicore.ml.core.evaluation.measure.multilabel.ExactMatchLoss;
import ai.libs.jaicore.ml.core.evaluation.measure.multilabel.F1MacroAverageLLoss;
import ai.libs.jaicore.ml.core.evaluation.measure.multilabel.HammingLoss;
import ai.libs.jaicore.ml.core.evaluation.measure.multilabel.RankLoss;
import java.util.Arrays;
import java.util.List;
import meka.core.Metrics;

public class AutoMEKAGGPFitnessMeasureLoss
extends ADecomposableMultilabelMeasure {
    private static final ExactMatchLoss EXACT_MATCH = new ExactMatchLoss();
    private static final HammingLoss HAMMING = new HammingLoss();
    private static final F1MacroAverageLLoss F1_MACRO_AVG_L = new F1MacroAverageLLoss();
    private static final RankLoss RANK = new RankLoss();

    @Override
    public Double calculateMeasure(double[] actual, double[] expected) {
        double exactMatchLoss = EXACT_MATCH.calculateMeasure(actual, expected);
        double hammingLoss = HAMMING.calculateMeasure(actual, expected);
        double f1MacroLoss = (Double)F1_MACRO_AVG_L.calculateMeasure(actual, expected);
        double rankLoss = Metrics.L_RankLoss((int[])Arrays.stream(expected).mapToInt(x -> (int)x).toArray(), (double[])actual);
        return (exactMatchLoss + hammingLoss + f1MacroLoss + rankLoss) / 4.0;
    }

    @Override
    public Double calculateAvgMeasure(List<double[]> actual, List<double[]> expected) {
        double[][] ypred = new double[actual.size()][];
        int[][] ypredint = new int[actual.size()][];
        for (int i = 0; i < actual.size(); ++i) {
            ypred[i] = actual.get(i);
            ypredint[i] = Arrays.stream(actual.get(i)).mapToInt(x -> x >= 0.5 ? 1 : 0).toArray();
        }
        int[][] y = new int[expected.size()][];
        for (int i = 0; i < expected.size(); ++i) {
            y[i] = Arrays.stream(expected.get(i)).mapToInt(x -> x >= 0.5 ? 1 : 0).toArray();
        }
        double hamming = Metrics.L_Hamming((int[][])y, (int[][])ypredint);
        double rank = Metrics.L_RankLoss((int[][])y, (double[][])ypred);
        double macroF = Metrics.P_FmacroAvgL((int[][])y, (int[][])ypredint);
        double exactMatch = Metrics.P_Accuracy((int[][])y, (int[][])ypredint);
        double fitnessMeasure = (1.0 - hamming + (1.0 - rank) + macroF + exactMatch) / 4.0;
        return 1.0 - fitnessMeasure;
    }
}

