/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.evaluation.measure.multilabel;

import ai.libs.jaicore.ml.core.evaluation.measure.ADecomposableDoubleMeasure;
import java.util.Arrays;
import java.util.List;
import meka.core.Metrics;

public class HammingLoss
extends ADecomposableDoubleMeasure<double[]> {
    @Override
    public Double calculateMeasure(double[] actual, double[] expected) {
        int score = 0;
        int numLabels = actual.length;
        for (int label = 0; label < numLabels; ++label) {
            if (actual[label] == expected[label]) continue;
            ++score;
        }
        return (double)score * 1.0 / (double)numLabels;
    }

    @Override
    public Double calculateAvgMeasure(List<double[]> actual, List<double[]> expected) {
        double[][] ypred = new double[actual.size()][];
        int[][] ypredint = new int[actual.size()][];
        for (int i = 0; i < actual.size(); ++i) {
            ypred[i] = actual.get(i);
            ypredint[i] = Arrays.stream(actual.get(i)).mapToInt(x -> x >= 0.5 ? 1 : 0).toArray();
        }
        int[][] y = new int[expected.size()][];
        for (int i = 0; i < expected.size(); ++i) {
            y[i] = Arrays.stream(expected.get(i)).mapToInt(x -> x >= 0.5 ? 1 : 0).toArray();
        }
        return Metrics.L_Hamming((int[][])y, (int[][])ypredint);
    }
}

