/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.evaluation.measure.singlelabel;

import ai.libs.jaicore.basic.aggregate.IAggregateFunction;
import ai.libs.jaicore.ml.core.evaluation.measure.IMeasure;
import java.util.List;

public class PrecisionAsLoss
implements IMeasure<Double, Double> {
    private final int positiveClass;

    public PrecisionAsLoss(int positiveClass) {
        this.positiveClass = positiveClass;
    }

    @Override
    public Double calculateMeasure(Double actual, Double expected) {
        throw new UnsupportedOperationException("Precision is a batch loss function.");
    }

    @Override
    public List<Double> calculateMeasure(List<Double> actual, List<Double> expected) {
        throw new UnsupportedOperationException("Precision is a batch loss function.");
    }

    @Override
    public Double calculateMeasure(List<Double> actual, List<Double> expected, IAggregateFunction<Double> aggregateFunction) {
        throw new UnsupportedOperationException("Precision is a batch loss function.");
    }

    @Override
    public Double calculateAvgMeasure(List<Double> actual, List<Double> expected) {
        int tp = 0;
        int fp = 0;
        for (int i = 0; i < actual.size(); ++i) {
            int actualValue = (int)actual.get(i).doubleValue();
            int expectedValue = (int)expected.get(i).doubleValue();
            if (actualValue != this.positiveClass) continue;
            if (actualValue == expectedValue) {
                ++tp;
                continue;
            }
            ++fp;
        }
        double precision = tp + fp > 0 ? (double)tp / (double)(tp + fp) : 0.0;
        return 1.0 - precision;
    }
}

