/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.evaluation.evaluators.weka;

import ai.libs.jaicore.basic.algorithm.exceptions.ObjectEvaluationFailedException;
import ai.libs.jaicore.ml.WekaUtil;
import ai.libs.jaicore.ml.core.evaluation.measure.IMeasure;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.IClassifierEvaluator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.classifiers.Classifier;
import weka.core.Instances;

public class CVEvaluator
implements IClassifierEvaluator {
    static final Logger logger = LoggerFactory.getLogger(CVEvaluator.class);
    private final IMeasure<Double, Double> evaluator;
    private boolean canceled = false;
    private final int folds;
    private Instances data;

    public CVEvaluator(IMeasure<Double, Double> evaluator, int folds) throws IOException {
        this.evaluator = evaluator;
        this.folds = folds;
    }

    public Double evaluate(Classifier c) throws ObjectEvaluationFailedException {
        DescriptiveStatistics stats = new DescriptiveStatistics();
        logger.info("Starting evaluation of {}", (Object)c);
        this.data.stratify(this.folds);
        for (int i = 0; i < this.folds && !this.canceled; ++i) {
            logger.info("Evaluating {} with split #{}/{}", new Object[]{c, i + 1, this.folds});
            Instances train = this.data.trainCV(this.folds, i);
            Instances test = this.data.testCV(this.folds, i);
            List<Double> actual = WekaUtil.getClassesAsList(test);
            ArrayList predicted = new ArrayList();
            try {
                c.buildClassifier(train);
            }
            catch (Exception e) {
                throw new ObjectEvaluationFailedException("Could not train classifier c", (Throwable)e);
            }
            double score = this.evaluator.calculateAvgMeasure(actual, predicted);
            logger.info("Score for evaluation of {} with split #{}/{}: {}", new Object[]{c, i + 1, this.folds, score});
            stats.addValue(score);
        }
        Double score = stats.getMean();
        logger.info("Obtained score of {} for classifier {}.", (Object)score, (Object)c);
        return score;
    }

    public Instances getData() {
        return this.data;
    }

    public void setData(Instances data) {
        this.data = data;
    }
}

