/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.evaluation.evaluators.weka;

import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.basic.algorithm.exceptions.ObjectEvaluationFailedException;
import ai.libs.jaicore.ml.core.dataset.IDataset;
import ai.libs.jaicore.ml.core.dataset.IInstance;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.ASamplingAlgorithm;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.factories.interfaces.ISamplingAlgorithmFactory;
import ai.libs.jaicore.ml.core.dataset.weka.WekaInstances;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.FixedSplitClassifierEvaluator;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.IClassifierEvaluator;
import ai.libs.jaicore.ml.interfaces.AnalyticalLearningCurve;
import ai.libs.jaicore.ml.learningcurve.extrapolation.InvalidAnchorPointsException;
import ai.libs.jaicore.ml.learningcurve.extrapolation.LearningCurveExtrapolationMethod;
import ai.libs.jaicore.ml.learningcurve.extrapolation.LearningCurveExtrapolator;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.classifiers.Classifier;
import weka.core.Instances;

public class ExtrapolatedSaturationPointEvaluator<I extends IInstance>
implements IClassifierEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(ExtrapolatedSaturationPointEvaluator.class);
    private static final double DEFAULT_EPSILON = 0.1;
    private int[] anchorpoints;
    private ISamplingAlgorithmFactory<I, ? extends ASamplingAlgorithm<I>> samplingAlgorithmFactory;
    private IDataset<I> train;
    private double trainSplitForAnchorpointsMeasurement;
    private LearningCurveExtrapolationMethod extrapolationMethod;
    private long seed;
    private double epsilon;
    private IDataset<I> test;

    public ExtrapolatedSaturationPointEvaluator(int[] anchorpoints, ISamplingAlgorithmFactory<I, ? extends ASamplingAlgorithm<I>> samplingAlgorithmFactory, IDataset<I> train, double trainSplitForAnchorpointsMeasurement, LearningCurveExtrapolationMethod extrapolationMethod, long seed, IDataset<I> test) {
        this.anchorpoints = anchorpoints;
        this.samplingAlgorithmFactory = samplingAlgorithmFactory;
        this.train = train;
        this.trainSplitForAnchorpointsMeasurement = trainSplitForAnchorpointsMeasurement;
        this.extrapolationMethod = extrapolationMethod;
        this.seed = seed;
        this.epsilon = 0.1;
        this.test = test;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public Double evaluate(Classifier classifier) throws InterruptedException, ObjectEvaluationFailedException {
        LearningCurveExtrapolator<I> extrapolator = new LearningCurveExtrapolator<I>(this.extrapolationMethod, classifier, this.train, this.trainSplitForAnchorpointsMeasurement, this.anchorpoints, this.samplingAlgorithmFactory, this.seed);
        try {
            AnalyticalLearningCurve learningCurve = (AnalyticalLearningCurve)extrapolator.extrapolateLearningCurve();
            int optimalSampleSize = Math.min(this.train.size(), (int)learningCurve.getSaturationPoint(this.epsilon));
            ASamplingAlgorithm<I> samplingAlgorithm = this.samplingAlgorithmFactory.getAlgorithm(optimalSampleSize, this.train, new Random(this.seed));
            Object saturationPointTrainSet = samplingAlgorithm.call();
            Instances saturationPointInstances = (Instances)((WekaInstances)saturationPointTrainSet).getList();
            Instances testInstances = (Instances)((WekaInstances)this.test).getList();
            FixedSplitClassifierEvaluator evaluator = new FixedSplitClassifierEvaluator(saturationPointInstances, testInstances);
            return evaluator.evaluate(classifier);
        }
        catch (AlgorithmExecutionCanceledException | AlgorithmException | InvalidAnchorPointsException e) {
            logger.warn("Evaluation of classifier failed due Exception {} with message {}. Returning null.", (Object)e.getClass().getName(), (Object)e.getMessage());
            return null;
        }
    }
}

