/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.evaluation.evaluators.weka.factory;

import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.ml.core.dataset.IDataset;
import ai.libs.jaicore.ml.core.dataset.IInstance;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.ASamplingAlgorithm;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.factories.interfaces.ISamplingAlgorithmFactory;
import ai.libs.jaicore.ml.core.dataset.standard.SimpleInstance;
import ai.libs.jaicore.ml.core.dataset.util.StratifiedSplit;
import ai.libs.jaicore.ml.core.dataset.weka.WekaInstancesUtil;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.ExtrapolatedSaturationPointEvaluator;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.IClassifierEvaluator;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.factory.IClassifierEvaluatorFactory;
import ai.libs.jaicore.ml.learningcurve.extrapolation.LearningCurveExtrapolationMethod;
import weka.core.Instances;

public class ExtrapolatedSaturationPointEvaluatorFactory
implements IClassifierEvaluatorFactory {
    private int[] anchorpoints;
    private ISamplingAlgorithmFactory<IInstance, ? extends ASamplingAlgorithm<IInstance>> subsamplingAlgorithmFactory;
    private double trainSplitForAnchorpointsMeasurement;
    private LearningCurveExtrapolationMethod extrapolationMethod;

    public ExtrapolatedSaturationPointEvaluatorFactory(int[] anchorpoints, ISamplingAlgorithmFactory<IInstance, ? extends ASamplingAlgorithm<IInstance>> subsamplingAlgorithmFactory, double trainSplitForAnchorpointsMeasurement, LearningCurveExtrapolationMethod extrapolationMethod) {
        this.anchorpoints = anchorpoints;
        this.subsamplingAlgorithmFactory = subsamplingAlgorithmFactory;
        this.trainSplitForAnchorpointsMeasurement = trainSplitForAnchorpointsMeasurement;
        this.extrapolationMethod = extrapolationMethod;
    }

    @Override
    public IClassifierEvaluator getIClassifierEvaluator(Instances dataset, long seed) {
        StratifiedSplit<SimpleInstance> split = new StratifiedSplit<SimpleInstance>(WekaInstancesUtil.wekaInstancesToDataset(dataset), seed);
        try {
            split.doSplit(0.7);
        }
        catch (AlgorithmException e) {
            throw new RuntimeException("Cannot compute split", e);
        }
        IDataset<SimpleInstance> train = split.getTrainingData();
        IDataset<SimpleInstance> test = split.getTestData();
        return new ExtrapolatedSaturationPointEvaluator<SimpleInstance>(this.anchorpoints, this.subsamplingAlgorithmFactory, train, this.trainSplitForAnchorpointsMeasurement, this.extrapolationMethod, seed, test);
    }
}

