/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.evaluation.evaluators.weka.splitevaluation;

import ai.libs.jaicore.basic.algorithm.exceptions.ObjectEvaluationFailedException;
import ai.libs.jaicore.ml.core.evaluation.measure.IMeasure;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.splitevaluation.AbstractSplitBasedClassifierEvaluator;
import java.util.LinkedList;
import meka.classifiers.multilabel.MultiLabelClassifier;
import meka.core.MLUtils;
import weka.classifiers.Classifier;
import weka.core.Instance;
import weka.core.Instances;

public class SimpleMLCSplitBasedClassifierEvaluator
extends AbstractSplitBasedClassifierEvaluator<double[], Double> {
    public SimpleMLCSplitBasedClassifierEvaluator(IMeasure<double[], Double> basicEvaluator) {
        super(basicEvaluator);
    }

    @Override
    public Double evaluateSplit(Classifier pl, Instances trainingData, Instances validationData) throws ObjectEvaluationFailedException, InterruptedException {
        try {
            pl.buildClassifier(trainingData);
            int numLabels = trainingData.classIndex();
            LinkedList<double[]> actual = new LinkedList<double[]>();
            LinkedList<double[]> expected = new LinkedList<double[]>();
            for (int i = 0; i < validationData.size(); ++i) {
                actual.add(pl.distributionForInstance(validationData.get(i)));
                expected.add(MLUtils.toDoubleArray((Instance)validationData.get(i), (int)numLabels));
                Double error = (Double)this.getBasicEvaluator().calculateAvgMeasure(actual, expected);
                if (!(error + "").equals("NaN")) continue;
                throw new ObjectEvaluationFailedException("Classifier " + pl.getClass().getName() + " could not be evalauted. Please refer to the previous logs for more detailed information.");
            }
            return (Double)this.getBasicEvaluator().calculateAvgMeasure(actual, expected);
        }
        catch (OutOfMemoryError e) {
            throw new ObjectEvaluationFailedException("Ran out of memory while building classifier " + ((MultiLabelClassifier)pl).getModel(), (Throwable)e);
        }
        catch (ObjectEvaluationFailedException | InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ObjectEvaluationFailedException("Could not train classifier");
        }
    }
}

