/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.evaluation.evaluators.weka.splitevaluation;

import ai.libs.jaicore.basic.algorithm.exceptions.ObjectEvaluationFailedException;
import ai.libs.jaicore.ml.WekaUtil;
import ai.libs.jaicore.ml.core.evaluation.measure.IMeasure;
import ai.libs.jaicore.ml.evaluation.IInstancesClassifier;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.splitevaluation.AbstractSplitBasedClassifierEvaluator;
import java.util.ArrayList;
import java.util.List;
import weka.classifiers.Classifier;
import weka.core.Instance;
import weka.core.Instances;

public class SimpleSLCSplitBasedClassifierEvaluator
extends AbstractSplitBasedClassifierEvaluator<Double, Double> {
    public SimpleSLCSplitBasedClassifierEvaluator(IMeasure<Double, Double> basicEvaluator) {
        super(basicEvaluator);
    }

    @Override
    public Double evaluateSplit(Classifier classifier, Instances trainingData, Instances validationData) throws ObjectEvaluationFailedException, InterruptedException {
        List<Double> actual = WekaUtil.getClassesAsList(validationData);
        ArrayList<Double> predicted = new ArrayList<Double>();
        try {
            classifier.buildClassifier(trainingData);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ObjectEvaluationFailedException("Could not build model.", (Throwable)e);
        }
        try {
            if (classifier instanceof IInstancesClassifier) {
                for (double prediction : ((IInstancesClassifier)classifier).classifyInstances(validationData)) {
                    predicted.add(prediction);
                }
            } else {
                for (Instance inst : validationData) {
                    predicted.add(classifier.classifyInstance(inst));
                }
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ObjectEvaluationFailedException("Could not validate classifier.", (Throwable)e);
        }
        return (Double)this.getBasicEvaluator().calculateAvgMeasure(actual, predicted);
    }
}

