/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.experiments;

import ai.libs.jaicore.basic.SQLAdapter;
import ai.libs.jaicore.ml.experiments.IMultiClassClassificationExperimentDatabase;
import ai.libs.jaicore.ml.experiments.MLExperiment;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import weka.classifiers.Classifier;

public class MySQLExperimentDatabaseHandle
extends SQLAdapter
implements IMultiClassClassificationExperimentDatabase {
    private Map<Integer, Classifier> run2classifier = new HashMap<Integer, Classifier>();
    private Map<Classifier, Integer> classifier2run = new HashMap<Classifier, Integer>();

    public MySQLExperimentDatabaseHandle(String host, String user, String password, String database) {
        super(host, user, password, database);
    }

    protected void beforeCreateRun(MLExperiment e) {
    }

    protected void afterCreateRun(MLExperiment e, int jobId) {
    }

    @Override
    public int createRunIfDoesNotExist(MLExperiment e) {
        try {
            String[] values = new String[]{InetAddress.getLocalHost().toString(), e.getDataset(), e.getAlgorithm(), e.getAlgorithmMode(), String.valueOf(e.getSeed()), String.valueOf(e.getTimeoutInSeconds()), String.valueOf(e.getCpus()), String.valueOf(e.getMemoryInMB()), e.getPerformanceMeasure()};
            this.beforeCreateRun(e);
            int id = this.insert("INSERT INTO `runs` (machine, dataset, algorithm, algorithmmode, seed, timeout, CPUs, memoryInMB, performancemeasure) VALUES (?,?,?,?,?,?,?,?,?)", values);
            this.afterCreateRun(e, id);
            return id;
        }
        catch (UnknownHostException | SQLException exc) {
            if (!exc.getMessage().startsWith("Duplicate entry")) {
                exc.printStackTrace();
            }
            return -1;
        }
    }

    @Override
    public void associatedRunWithClassifier(int runId, Classifier c) {
        this.run2classifier.put(runId, c);
        this.classifier2run.put(c, runId);
    }

    public int getRunIdOfClassifier(Classifier c) {
        return this.classifier2run.get(c);
    }

    public Classifier getClassifierOfRun(int jobId) {
        return this.run2classifier.get(jobId);
    }

    @Override
    public Collection<MLExperiment> getExperimentsForWhichARunExists() throws Exception {
        ResultSet rs = this.getResultsOfQuery("SELECT dataset, algorithm, algorithmmode, seed, timeout, cpus, memoryinmb, performancemeasure FROM `runs`");
        ArrayList<MLExperiment> list = new ArrayList<MLExperiment>();
        while (rs.next()) {
            list.add(new MLExperiment(rs.getString(1), rs.getString(2), rs.getString(3), rs.getInt(4), rs.getInt(5), rs.getInt(6), rs.getInt(7), rs.getString(8)));
        }
        return list;
    }

    @Override
    public void updateExperiment(MLExperiment e, Map<String, String> data) throws Exception {
        HashMap<String, String> whereClause = new HashMap<String, String>();
        whereClause.put("dataset", e.getDataset());
        whereClause.put("algorithm", e.getAlgorithm());
        whereClause.put("algorithmmode", e.getAlgorithmMode());
        whereClause.put("seed", String.valueOf(e.getSeed()));
        whereClause.put("timeout", String.valueOf(e.getTimeoutInSeconds()));
        whereClause.put("cpus", String.valueOf(e.getCpus()));
        whereClause.put("memoryinmb", String.valueOf(e.getMemoryInMB()));
        whereClause.put("performancemeasure", String.valueOf(e.getPerformanceMeasure()));
        this.update("runs", data, whereClause);
    }

    @Override
    public void addResultEntry(int runId, double score) throws Exception {
        HashMap<String, String> whereClause = new HashMap<String, String>();
        whereClause.put("run_id", String.valueOf(runId));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("errorRate", String.valueOf(score));
        this.update("runs", data, whereClause);
    }
}

