/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.learningcurve.extrapolation.ipl;

import ai.libs.jaicore.ml.interfaces.LearningCurve;
import ai.libs.jaicore.ml.learningcurve.extrapolation.InvalidAnchorPointsException;
import ai.libs.jaicore.ml.learningcurve.extrapolation.LearningCurveExtrapolationMethod;
import ai.libs.jaicore.ml.learningcurve.extrapolation.client.ExtrapolationServiceClient;
import ai.libs.jaicore.ml.learningcurve.extrapolation.ipl.InversePowerLawConfiguration;
import ai.libs.jaicore.ml.learningcurve.extrapolation.ipl.InversePowerLawLearningCurve;
import java.util.concurrent.ExecutionException;

public class InversePowerLawExtrapolationMethod
implements LearningCurveExtrapolationMethod {
    private static final String ENDPOINT = "/jaicore/web/api/v1/ipl/modelparams";
    private static final String DEFAULT_HOST = "localhost";
    private static final String DEFAULT_PORT = "8081";
    private String serviceUrl;

    public InversePowerLawExtrapolationMethod() {
        this.serviceUrl = "http://localhost:8081/jaicore/web/api/v1/ipl/modelparams";
    }

    public InversePowerLawExtrapolationMethod(String serviceHost, String port) {
        this.serviceUrl = "http://" + serviceHost + ":" + port + ENDPOINT;
    }

    @Override
    public LearningCurve extrapolateLearningCurveFromAnchorPoints(int[] xValues, double[] yValues, int dataSetSize) throws InvalidAnchorPointsException, InterruptedException, ExecutionException {
        ExtrapolationServiceClient<InversePowerLawConfiguration> client = new ExtrapolationServiceClient<InversePowerLawConfiguration>(this.serviceUrl, InversePowerLawConfiguration.class);
        InversePowerLawConfiguration configuration = client.getConfigForAnchorPoints(xValues, yValues);
        configuration.setA(Math.max(1.0E-11, Math.min(configuration.getA(), 0.99999999999)));
        configuration.setC(Math.max(-0.99999999999, Math.min(configuration.getC(), -1.0E-11)));
        return new InversePowerLawLearningCurve(configuration);
    }
}

