/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.learningcurve.extrapolation.lc;

import ai.libs.jaicore.ml.interfaces.LearningCurve;
import ai.libs.jaicore.ml.learningcurve.extrapolation.InvalidAnchorPointsException;
import ai.libs.jaicore.ml.learningcurve.extrapolation.LearningCurveExtrapolationMethod;
import ai.libs.jaicore.ml.learningcurve.extrapolation.client.ExtrapolationServiceClient;
import ai.libs.jaicore.ml.learningcurve.extrapolation.lc.LinearCombinationLearningCurve;
import ai.libs.jaicore.ml.learningcurve.extrapolation.lc.LinearCombinationLearningCurveConfiguration;
import java.util.concurrent.ExecutionException;

public class LinearCombinationExtrapolationMethod
implements LearningCurveExtrapolationMethod {
    private static final String ENDPOINT = "/jaicore/web/api/v1/mcmc/modelparams";
    private static final String DEFAULT_HOST = "localhost";
    private static final String DEFAULT_PORT = "8080";
    private String serviceUrl;

    public LinearCombinationExtrapolationMethod() {
        this.serviceUrl = "http://localhost:8080/jaicore/web/api/v1/mcmc/modelparams";
    }

    public LinearCombinationExtrapolationMethod(String serviceHost, String port) {
        this.serviceUrl = "http://" + serviceHost + ":" + port + ENDPOINT;
    }

    @Override
    public LearningCurve extrapolateLearningCurveFromAnchorPoints(int[] xValues, double[] yValues, int dataSetSize) throws InvalidAnchorPointsException, InterruptedException, ExecutionException {
        ExtrapolationServiceClient<LinearCombinationLearningCurveConfiguration> client = new ExtrapolationServiceClient<LinearCombinationLearningCurveConfiguration>(this.serviceUrl, LinearCombinationLearningCurveConfiguration.class);
        LinearCombinationLearningCurveConfiguration configuration = client.getConfigForAnchorPoints(xValues, yValues);
        return new LinearCombinationLearningCurve(configuration, dataSetSize);
    }
}

