/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.metafeatures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.time.StopWatch;
import org.openml.webapplication.fantail.dc.Characterizer;
import org.openml.webapplication.fantail.dc.landmarking.GenericLandmarker;
import org.openml.webapplication.fantail.dc.statistical.Cardinality;
import org.openml.webapplication.fantail.dc.statistical.NominalAttDistinctValues;
import org.openml.webapplication.fantail.dc.statistical.SimpleMetaFeatures;
import org.openml.webapplication.fantail.dc.statistical.Statistical;
import weka.core.Instances;
import weka.core.Utils;

public class GlobalCharacterizer
extends Characterizer {
    private final String preprocessingPrefix = "-E \"weka.attributeSelection.CfsSubsetEval -P 1 -E 1\" -S \"weka.attributeSelection.BestFirst -D 1 -N 5\" -W ";
    private final String cp1NN = "weka.classifiers.lazy.IBk";
    private final String cpNB = "weka.classifiers.bayes.NaiveBayes";
    private final String cpASC = "weka.classifiers.meta.AttributeSelectedClassifier";
    private final String cpDS = "weka.classifiers.trees.DecisionStump";
    protected String[] ids;
    protected ArrayList<Characterizer> characterizers;
    protected Map<Characterizer, String> characterizerNames;
    protected Map<String, Double> computationTimes = new HashMap<String, Double>();

    public GlobalCharacterizer() throws Exception {
        this.initializeCharacterizers();
        this.initializeCharacterizerNames();
        this.initializeMetaFeatureIds();
    }

    public Map<String, Double> characterize(Instances instances) {
        TreeMap<String, Double> metaFeatures = new TreeMap<String, Double>();
        StopWatch watch = new StopWatch();
        this.characterizers.forEach(characterizer -> {
            try {
                watch.reset();
                watch.start();
                metaFeatures.putAll(characterizer.characterize(instances));
                watch.stop();
                this.computationTimes.put(characterizer.toString(), Double.valueOf(watch.getTime()));
            }
            catch (Exception e) {
                for (String metaFeature : characterizer.getIDs()) {
                    metaFeatures.put(metaFeature, Double.NaN);
                }
                this.computationTimes.put(characterizer.toString(), Double.NaN);
            }
        });
        return metaFeatures;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Characterizer characterizer : this.characterizers) {
            String[] ids;
            builder.append(characterizer.toString());
            builder.append(System.lineSeparator());
            for (String id : ids = characterizer.getIDs()) {
                builder.append(id + ",");
            }
            builder.append(System.lineSeparator());
        }
        return builder.toString();
    }

    public ArrayList<Characterizer> getCharacterizers() {
        return this.characterizers;
    }

    public Map<String, Double> getMetaFeatureComputationTimes() {
        return this.computationTimes;
    }

    public List<String> getCharacterizerNames() {
        ArrayList<String> names = new ArrayList<String>();
        this.characterizerNames.values().forEach(name -> names.add((String)name));
        return names;
    }

    public Map<Characterizer, String> getCharacterizerNamesMappings() {
        return this.characterizerNames;
    }

    public Map<String, List<String>> getCharacterizerGroups() {
        HashMap<String, List<String>> results = new HashMap<String, List<String>>();
        this.characterizerNames.forEach((characterizer, name) -> results.put((String)name, Arrays.asList(characterizer.getIDs())));
        return results;
    }

    public String[] getIDs() {
        return this.ids;
    }

    protected void initializeCharacterizers() throws Exception {
        Characterizer[] characterizerArray = new Characterizer[]{new SimpleMetaFeatures(), new Statistical(), new NominalAttDistinctValues(), new Cardinality(), new GenericLandmarker("kNN1N", "weka.classifiers.lazy.IBk", 2, null), new GenericLandmarker("NaiveBayes", "weka.classifiers.bayes.NaiveBayes", 2, null), new GenericLandmarker("DecisionStump", "weka.classifiers.trees.DecisionStump", 2, null), new GenericLandmarker("CfsSubsetEval_kNN1N", "weka.classifiers.meta.AttributeSelectedClassifier", 2, Utils.splitOptions((String)"-E \"weka.attributeSelection.CfsSubsetEval -P 1 -E 1\" -S \"weka.attributeSelection.BestFirst -D 1 -N 5\" -W weka.classifiers.lazy.IBk")), new GenericLandmarker("CfsSubsetEval_NaiveBayes", "weka.classifiers.meta.AttributeSelectedClassifier", 2, Utils.splitOptions((String)"-E \"weka.attributeSelection.CfsSubsetEval -P 1 -E 1\" -S \"weka.attributeSelection.BestFirst -D 1 -N 5\" -W weka.classifiers.bayes.NaiveBayes")), new GenericLandmarker("CfsSubsetEval_DecisionStump", "weka.classifiers.meta.AttributeSelectedClassifier", 2, Utils.splitOptions((String)"-E \"weka.attributeSelection.CfsSubsetEval -P 1 -E 1\" -S \"weka.attributeSelection.BestFirst -D 1 -N 5\" -W weka.classifiers.trees.DecisionStump"))};
        ArrayList<Characterizer> characterizerList = new ArrayList<Characterizer>(Arrays.asList(characterizerArray));
        String zeros = "0";
        for (int i = 1; i <= 3; ++i) {
            zeros = zeros + "0";
            String[] j48Option = new String[]{"-C", "." + zeros + "1"};
            characterizerList.add((Characterizer)new GenericLandmarker("J48." + zeros + "1.", "weka.classifiers.trees.J48", 2, j48Option));
            String[] repOption = new String[]{"-L", "" + i};
            characterizerList.add((Characterizer)new GenericLandmarker("REPTreeDepth" + i, "weka.classifiers.trees.REPTree", 2, repOption));
            String[] randomtreeOption = new String[]{"-depth", "" + i};
            characterizerList.add((Characterizer)new GenericLandmarker("RandomTreeDepth" + i, "weka.classifiers.trees.RandomTree", 2, randomtreeOption));
        }
        this.characterizers = characterizerList;
    }

    protected void initializeCharacterizerNames() {
        this.characterizerNames = new HashMap<Characterizer, String>();
        this.characterizers.forEach(characterizer -> {
            if (characterizer.getClass().equals(GenericLandmarker.class)) {
                String AUCName = characterizer.getIDs()[0];
                String name = AUCName.substring(0, AUCName.length() - 3);
                this.characterizerNames.put((Characterizer)characterizer, name);
            } else {
                this.characterizerNames.put((Characterizer)characterizer, characterizer.getClass().getSimpleName());
            }
        });
    }

    protected void initializeMetaFeatureIds() {
        ArrayList<String> metaFeatures = new ArrayList<String>();
        for (Characterizer characterizer : this.characterizers) {
            for (String metaFeature : characterizer.getIDs()) {
                metaFeatures.add(metaFeature);
            }
        }
        this.ids = metaFeatures.toArray(new String[metaFeatures.size()]);
    }
}

