/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.openml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openml.apiconnector.io.OpenmlConnector;
import org.openml.apiconnector.xml.Data;
import org.openml.apiconnector.xml.DataFeature;
import org.openml.apiconnector.xml.DataSetDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.core.Attribute;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;

public class OpenMLHelper {
    private static final Logger logger = LoggerFactory.getLogger(OpenMLHelper.class);
    private static final String DATASET_INDEX = "resources/datasets";
    private static final String API_KEY = "resources/apikey.txt";
    private static String apiKey;

    public static List<Integer> getDataSetsFromIndex() throws IOException {
        ArrayList<Integer> dataSets = new ArrayList<Integer>();
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(DATASET_INDEX, new String[0]), StandardCharsets.UTF_8);){
            String line = null;
            while ((line = reader.readLine()) != null) {
                int dataSetId = Integer.parseInt(line);
                dataSets.add(dataSetId);
            }
        }
        catch (IOException e) {
            logger.error("IOException while trying to read data-set indices", (Throwable)e);
        }
        return dataSets;
    }

    public static ConverterUtils.DataSource getDataSourceById(int dataId) throws IOException {
        if (API_KEY == null) {
            try (BufferedReader reader = Files.newBufferedReader(Paths.get(API_KEY, new String[0]), StandardCharsets.UTF_8);){
                apiKey = reader.readLine();
            }
            catch (IOException e) {
                logger.error("Failed to read api_key", (Throwable)e);
            }
        }
        OpenmlConnector client = new OpenmlConnector();
        try {
            DataSetDescription description = client.dataGet(dataId);
            File file = description.getDataset(apiKey);
            return new ConverterUtils.DataSource(file.getCanonicalPath());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public static Instances getInstancesById(int dataId) throws IOException {
        Instances dataset = null;
        try {
            OpenmlConnector client = new OpenmlConnector();
            DataSetDescription description = client.dataGet(dataId);
            ConverterUtils.DataSource source = OpenMLHelper.getDataSourceById(dataId);
            dataset = source.getDataSet();
            Attribute targetAttribute = dataset.attribute(description.getDefault_target_attribute());
            dataset.setClassIndex(targetAttribute.index());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return dataset;
    }

    public static void createDataSetIndex(int maxNumFeatures, int maxNumInstances) throws Exception {
        int filteredBNG = 0;
        int filteredARFF = 0;
        int filteredTarget = 0;
        int filteredNumeric = 0;
        int fitForAnalysis = 0;
        BufferedWriter writer = Files.newBufferedWriter(FileSystems.getDefault().getPath("resources/datasets_" + maxNumFeatures + "_" + maxNumInstances, new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);
        OpenmlConnector client = new OpenmlConnector();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("status", "active");
        Data data = client.dataList(map);
        Data.DataSet[] data_raw = data.getData();
        int unfiltered = data_raw.length;
        for (int i = 0; i < data_raw.length; ++i) {
            String numInst;
            System.out.println("Progress: " + Math.round((double)i * 1.0 / (double)data_raw.length * 100.0));
            if (data_raw[i].getName().contains("BNG")) {
                ++filteredBNG;
                continue;
            }
            if (!data_raw[i].getFormat().equals("ARFF")) {
                ++filteredARFF;
                continue;
            }
            DataFeature dataFeature = client.dataFeatures(data_raw[i].getDid());
            DataFeature.Feature[] features = dataFeature.getFeatures();
            if (maxNumFeatures > 0 && features.length > maxNumFeatures) continue;
            boolean noTarget = true;
            boolean numericTarget = true;
            for (int j = features.length - 1; j >= 0; --j) {
                if (!features[j].getIs_target().booleanValue()) continue;
                noTarget = false;
                if (!features[j].getDataType().equals("numeric")) break;
                numericTarget = false;
                break;
            }
            if ((numInst = (String)data_raw[i].getQualityMap().get("NumberOfInstances")) == null) {
                System.out.println("Couldn't get num inst");
            } else if (Double.parseDouble(numInst) > (double)maxNumInstances) continue;
            if (noTarget) {
                ++filteredTarget;
                continue;
            }
            if (numericTarget) {
                ++filteredNumeric;
                continue;
            }
            writer.write(Integer.toString(data_raw[i].getDid()));
            writer.newLine();
            ++fitForAnalysis;
        }
        writer.close();
        System.out.println("Unfiltered: " + unfiltered);
        System.out.println("BNG: " + filteredBNG);
        System.out.println("ARFF: " + filteredARFF);
        System.out.println("No target: " + filteredTarget);
        System.out.println("Numeric target: " + filteredNumeric);
        System.out.println("Fit for analysis: " + fitForAnalysis);
    }

    public static void main(String[] args) {
        try {
            OpenMLHelper.createDataSetIndex(-1, -1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setApiKey(String apiKey) {
        OpenMLHelper.apiKey = apiKey;
    }
}

