/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.weka.dataset.splitter;

import ai.libs.jaicore.ml.WekaUtil;
import ai.libs.jaicore.ml.weka.dataset.splitter.IMultilabelCrossValidation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import weka.core.Instances;

public class RandomMultilabelCrossValidation
implements IMultilabelCrossValidation {
    private static final String NAME = "PseudoRandom";
    private static final String SPLIT_SEPARATOR = "/";

    @Override
    public Instances getTestSplit(Instances data, int seed, int fold, String splitInfo) {
        return this.getFolds(data, seed, splitInfo).get(fold);
    }

    @Override
    public Instances getTrainSplit(Instances data, int seed, int fold, String splitInfo) {
        List<Instances> folds = this.getFolds(data, seed, splitInfo);
        Instances trainInstances = new Instances(data, 0);
        for (int i = 0; i < folds.size(); ++i) {
            if (i == fold) continue;
            trainInstances.addAll((Collection)folds.get(i));
        }
        return trainInstances;
    }

    private List<Instances> getFolds(Instances data, int seed, String splitInfo) {
        Collection<Integer>[] instancesInFolds = WekaUtil.getArbitrarySplit(data, new Random(seed), Arrays.stream(splitInfo.split(this.getSplitSeparator())).mapToDouble(Double::parseDouble).toArray());
        return WekaUtil.realizeSplit(data, instancesInFolds);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getSplitSeparator() {
        return SPLIT_SEPARATOR;
    }
}

