/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.attribute.multivalue;

import ai.libs.jaicore.ml.core.dataset.attribute.IAttributeValue;
import ai.libs.jaicore.ml.core.dataset.attribute.multivalue.IMultiValueAttributeType;
import ai.libs.jaicore.ml.core.dataset.attribute.multivalue.MultiValueAttributeValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

public class MultiValueAttributeType
implements IMultiValueAttributeType {
    private final Set<String> domain;

    public MultiValueAttributeType(Set<String> domain) {
        this.domain = domain;
    }

    @Override
    public Set<String> getDomain() {
        return this.domain;
    }

    @Override
    public boolean isValidValue(Collection<String> value) {
        return this.domain.containsAll(value);
    }

    @Override
    public IAttributeValue<Collection<String>> buildAttributeValue(Object value) {
        return new MultiValueAttributeValue(this, (Set)value);
    }

    @Override
    public IAttributeValue<Collection<String>> buildAttributeValue(String stringDescription) {
        Set value = Arrays.stream(stringDescription.split(",")).collect(Collectors.toSet());
        return this.buildAttributeValue(value);
    }
}

