/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.sampling.infiles;

import ai.libs.jaicore.basic.TempFileHandler;
import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.ml.core.dataset.ArffUtilities;
import ai.libs.jaicore.ml.core.dataset.sampling.SampleElementAddedEvent;
import ai.libs.jaicore.ml.core.dataset.sampling.infiles.AFileSamplingAlgorithm;
import ai.libs.jaicore.ml.core.dataset.sampling.infiles.DatasetFileSorter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.UUID;

public class SystematicFileSampling
extends AFileSamplingAlgorithm {
    private Random random;
    private int index;
    private int addedDatapoints;
    private TempFileHandler tempFileHandler;
    private Comparator<String> datapointComparator;
    private BufferedReader sortedDatasetFileReader;
    private List<Integer> indicesForSelection;

    public SystematicFileSampling(Random random, File input) {
        this(random, null, input);
    }

    public SystematicFileSampling(Random random, Comparator<String> datapointComparator, File input) {
        super(input);
        this.random = random;
        this.datapointComparator = datapointComparator;
        this.tempFileHandler = new TempFileHandler();
    }

    public AlgorithmEvent nextWithException() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmException {
        switch (this.getState()) {
            case CREATED: {
                File sortedDatasetFile = null;
                try {
                    DatasetFileSorter sorter = new DatasetFileSorter((File)this.getInput(), this.tempFileHandler);
                    if (this.datapointComparator != null) {
                        sorter.setComparator(this.datapointComparator);
                    }
                    sortedDatasetFile = sorter.sort(this.tempFileHandler.getTempFileDirPath() + File.separator + UUID.randomUUID().toString());
                    sortedDatasetFile.deleteOnExit();
                    this.sortedDatasetFileReader = new BufferedReader(new FileReader(sortedDatasetFile));
                    ArffUtilities.skipWithReaderToDatapoints(this.sortedDatasetFileReader);
                }
                catch (IOException e) {
                    throw new AlgorithmException((Throwable)e, "Was not able to create a sorted dataset file.");
                }
                try {
                    this.addedDatapoints = 0;
                    this.index = 0;
                    int datapointAmount = ArffUtilities.countDatasetEntries(sortedDatasetFile, true);
                    this.indicesForSelection = new LinkedList<Integer>();
                    int k = datapointAmount / this.sampleSize;
                    int startIndex = this.random.nextInt(datapointAmount);
                    int i = 0;
                    while (this.indicesForSelection.size() < this.sampleSize) {
                        int e = (startIndex + k * i++) % datapointAmount;
                        this.indicesForSelection.add(e);
                    }
                    this.indicesForSelection.sort(Integer::compare);
                    return this.activate();
                }
                catch (IOException e) {
                    throw new AlgorithmException((Throwable)e, "Was not able to count the datapoints.");
                }
            }
            case ACTIVE: {
                if (this.addedDatapoints < this.sampleSize) {
                    try {
                        int e = this.indicesForSelection.get(this.addedDatapoints);
                        String datapoint = this.sortedDatasetFileReader.readLine();
                        ++this.index;
                        while (this.index < e) {
                            datapoint = this.sortedDatasetFileReader.readLine();
                            ++this.index;
                        }
                        assert (datapoint != null);
                        this.outputFileWriter.write(datapoint + "\n");
                        ++this.addedDatapoints;
                        return new SampleElementAddedEvent(this.getId());
                    }
                    catch (IOException e) {
                        throw new AlgorithmException((Throwable)e, "Was not able to read from sorted dataset file.");
                    }
                }
                this.cleanUp();
                return this.terminate();
            }
            case INACTIVE: {
                this.cleanUp();
                if (this.addedDatapoints < this.sampleSize) {
                    throw new AlgorithmException("Expected sample size was not reached before termination");
                }
                return this.terminate();
            }
        }
        this.cleanUp();
        throw new IllegalStateException("Unknown algorithm state " + this.getState());
    }

    @Override
    protected void cleanUp() {
        this.tempFileHandler.cleanUp();
    }
}

