/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.sampling.inmemory;

import ai.libs.jaicore.basic.algorithm.AAlgorithm;
import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.EAlgorithmState;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmTimeoutedException;
import ai.libs.jaicore.ml.core.dataset.DatasetCreationException;
import ai.libs.jaicore.ml.core.dataset.IDataset;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.ISamplingAlgorithm;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ASamplingAlgorithm<D extends IDataset<?>>
extends AAlgorithm<D, D>
implements ISamplingAlgorithm<D> {
    private static final Logger LOG = LoggerFactory.getLogger(ASamplingAlgorithm.class);
    protected Integer sampleSize = null;
    protected D sample = null;

    protected ASamplingAlgorithm(D input) {
        super(input);
    }

    public void setSampleSize(int size) {
        this.sampleSize = size;
    }

    public D call() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmException {
        Instant timeoutTime = null;
        if (this.getTimeout().milliseconds() <= 0L) {
            LOG.debug("Invalid or no timeout set. There will be no timeout in this algorithm run");
            timeoutTime = Instant.MAX;
        } else {
            timeoutTime = Instant.now().plus(this.getTimeout().milliseconds(), ChronoUnit.MILLIS);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set timeout to {}", (Object)timeoutTime);
            }
        }
        if (this.sampleSize == null) {
            throw new AlgorithmException("No valid sample size specified");
        }
        if (this.sampleSize == 0) {
            LOG.warn("Sample size is 0, so an empty data set is returned!");
            try {
                return (D)((IDataset)this.getInput()).createEmpty();
            }
            catch (DatasetCreationException e) {
                throw new AlgorithmException((Throwable)e, "Could not create a copy of the dataset.");
            }
        }
        IDataset dataset = (IDataset)this.getInput();
        if (dataset == null || dataset.isEmpty()) {
            throw new AlgorithmException("No dataset or an empty dataset was given as an input.");
        }
        if (dataset.size() < this.sampleSize) {
            throw new AlgorithmException("Specified sample size is bigger than the dataset.");
        }
        if (dataset.size() == this.sampleSize.intValue()) {
            LOG.warn("Sample size and data set size are equal. Returning the original data set");
            return (D)dataset;
        }
        this.setState(EAlgorithmState.CREATED);
        while (this.hasNext()) {
            try {
                this.checkAndConductTermination();
            }
            catch (AlgorithmTimeoutedException e) {
                throw new AlgorithmException(e.getMessage());
            }
            if (Instant.now().isAfter(timeoutTime)) {
                LOG.warn("Algorithm is running even though it has been timeouted. Cancelling..");
                this.cancel();
                throw new AlgorithmException("Algorithm is running even though it has been timeouted");
            }
            this.next();
        }
        return this.sample;
    }

    protected AlgorithmEvent doInactiveStep() throws AlgorithmException {
        if (this.sample.size() < this.sampleSize) {
            throw new AlgorithmException("Expected sample size was not reached before termination");
        }
        return this.terminate();
    }
}

