/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.sampling.inmemory;

import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.ml.clustering.GMeans;
import ai.libs.jaicore.ml.core.dataset.DatasetCreationException;
import ai.libs.jaicore.ml.core.dataset.IDataset;
import ai.libs.jaicore.ml.core.dataset.INumericLabeledAttributeArrayInstance;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.ClusterSampling;
import java.util.Collection;
import org.apache.commons.math3.ml.distance.DistanceMeasure;

public class GmeansSampling<I extends INumericLabeledAttributeArrayInstance<? extends Number>, D extends IDataset<I>>
extends ClusterSampling<I, D> {
    public GmeansSampling(long seed, DistanceMeasure dist, D input) {
        super(seed, dist, input);
    }

    public GmeansSampling(long seed, D input) {
        super(seed, input);
    }

    public AlgorithmEvent nextWithException() throws AlgorithmException {
        switch (this.getState()) {
            case CREATED: {
                try {
                    this.sample = ((IDataset)this.getInput()).createEmpty();
                }
                catch (DatasetCreationException e) {
                    throw new AlgorithmException((Throwable)e, "Could not create a copy of the dataset.");
                }
                if (this.clusterResults == null) {
                    GMeans gMeansCluster = new GMeans((Collection)this.getInput(), this.distanceMeassure, this.seed);
                    this.clusterResults = gMeansCluster.cluster();
                }
                return this.activate();
            }
            case ACTIVE: {
                this.doAlgorithmStep();
                break;
            }
            case INACTIVE: {
                this.doInactiveStep();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown algorithm state " + this.getState());
            }
        }
        return null;
    }
}

