/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.sampling.inmemory;

import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.ml.core.dataset.DatasetCreationException;
import ai.libs.jaicore.ml.core.dataset.IDataset;
import ai.libs.jaicore.ml.core.dataset.INumericLabeledAttributeArrayInstance;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.ClusterSampling;
import java.util.Collection;
import org.apache.commons.math3.ml.clustering.KMeansPlusPlusClusterer;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.commons.math3.random.RandomGenerator;

public class KmeansSampling<I extends INumericLabeledAttributeArrayInstance<? extends Number>, D extends IDataset<I>>
extends ClusterSampling<I, D> {
    private int k;

    public KmeansSampling(long seed, int k, D input) {
        super(seed, input);
        this.k = k;
    }

    public KmeansSampling(long seed, DistanceMeasure dist, D input) {
        super(seed, dist, input);
        this.k = -1;
    }

    public KmeansSampling(long seed, int k, DistanceMeasure dist, D input) {
        super(seed, dist, input);
        this.k = k;
    }

    public AlgorithmEvent nextWithException() throws AlgorithmException {
        switch (this.getState()) {
            case CREATED: {
                try {
                    this.sample = ((IDataset)this.getInput()).createEmpty();
                }
                catch (DatasetCreationException e) {
                    throw new AlgorithmException((Throwable)e, "Could not create a copy of the dataset.");
                }
                JDKRandomGenerator r = new JDKRandomGenerator();
                r.setSeed(this.seed);
                if (this.k == -1) {
                    this.k = this.sampleSize;
                }
                if (this.clusterResults == null) {
                    KMeansPlusPlusClusterer kMeansCluster = new KMeansPlusPlusClusterer(this.k, -1, this.distanceMeassure, (RandomGenerator)r);
                    this.clusterResults = kMeansCluster.cluster((Collection)this.getInput());
                }
                return this.activate();
            }
            case ACTIVE: {
                this.doAlgorithmStep();
                break;
            }
            case INACTIVE: {
                this.doInactiveStep();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown algorithm state " + this.getState());
            }
        }
        return null;
    }
}

