/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.sampling.inmemory;

import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.ml.core.dataset.DatasetCreationException;
import ai.libs.jaicore.ml.core.dataset.IOrderedDataset;
import ai.libs.jaicore.ml.core.dataset.sampling.SampleElementAddedEvent;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.ASamplingAlgorithm;
import java.util.Collection;
import java.util.Random;

public class SimpleRandomSampling<I, D extends IOrderedDataset<I>>
extends ASamplingAlgorithm<D> {
    private Random random;
    private D copyDataset;

    public SimpleRandomSampling(Random random, D input) {
        super(input);
        this.random = random;
    }

    public AlgorithmEvent nextWithException() throws AlgorithmException {
        switch (this.getState()) {
            case CREATED: {
                try {
                    this.sample = (IOrderedDataset)((IOrderedDataset)this.getInput()).createEmpty();
                    this.copyDataset = (IOrderedDataset)((IOrderedDataset)this.getInput()).createEmpty();
                    this.copyDataset.addAll((Collection)this.getInput());
                }
                catch (DatasetCreationException e) {
                    throw new AlgorithmException((Throwable)e, "Could not create a copy of the dataset.");
                }
                return this.activate();
            }
            case ACTIVE: {
                if (((IOrderedDataset)this.sample).size() < this.sampleSize) {
                    int i = this.random.nextInt(this.copyDataset.size());
                    ((IOrderedDataset)this.sample).add(this.copyDataset.get(i));
                    this.copyDataset.remove(i);
                    return new SampleElementAddedEvent(this.getId());
                }
                return this.terminate();
            }
            case INACTIVE: {
                this.doInactiveStep();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown algorithm state " + this.getState());
            }
        }
        return null;
    }
}

